/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.netflix.client.config.Property;
import java.util.function.Consumer;

public final class FallbackProperty<T>
implements Property<T> {
    private final Property<T> primary;
    private final Property<T> fallback;

    public FallbackProperty(Property<T> primary, Property<T> fallback) {
        this.primary = primary;
        this.fallback = fallback;
    }

    @Override
    public void onChange(Consumer<T> consumer) {
        this.primary.onChange(ignore -> consumer.accept(this.get()));
        this.fallback.onChange(ignore -> consumer.accept(this.get()));
    }

    @Override
    public T get() {
        return (T)this.primary.getOptional().orElseGet(this.fallback::get);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

