/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.spec;

import com.netflix.nfgraph.exception.NFGraphException;
import com.netflix.nfgraph.spec.NFPropertySpec;
import com.netflix.nfgraph.util.ArrayIterator;
import java.util.Iterator;

public class NFNodeSpec
implements Iterable<NFPropertySpec> {
    private final String nodeTypeName;
    private final NFPropertySpec[] propertySpecs;
    private final int numSingleProperties;
    private final int numMultipleProperties;

    public NFNodeSpec(String nodeTypeName, NFPropertySpec ... propertySpecs) {
        this.nodeTypeName = nodeTypeName;
        this.propertySpecs = propertySpecs;
        int numSingleProperties = 0;
        int numMultipleProperties = 0;
        for (NFPropertySpec propertySpec : propertySpecs) {
            propertySpec.setPropertyIndex(propertySpec.isSingle() ? numSingleProperties++ : numMultipleProperties++);
        }
        this.numSingleProperties = numSingleProperties;
        this.numMultipleProperties = numMultipleProperties;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public NFPropertySpec[] getPropertySpecs() {
        return this.propertySpecs;
    }

    public NFPropertySpec getPropertySpec(String propertyName) {
        for (NFPropertySpec spec : this.propertySpecs) {
            if (!spec.getName().equals(propertyName)) continue;
            return spec;
        }
        throw new NFGraphException("Property " + propertyName + " is undefined for node type " + this.nodeTypeName);
    }

    public int getNumSingleProperties() {
        return this.numSingleProperties;
    }

    public int getNumMultipleProperties() {
        return this.numMultipleProperties;
    }

    @Override
    public Iterator<NFPropertySpec> iterator() {
        return new ArrayIterator<NFPropertySpec>(this.propertySpecs);
    }
}

