/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.serializer;

import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.compressed.NFCompressedGraphPointers;
import com.netflix.nfgraph.spec.NFGraphSpec;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import com.netflix.nfgraph.util.ByteArrayBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class NFCompressedGraphSerializer {
    private final NFGraphSpec spec;
    private final NFGraphModelHolder modelHolder;
    private final NFCompressedGraphPointers pointers;
    private final byte[] data;

    public NFCompressedGraphSerializer(NFGraphSpec spec, NFGraphModelHolder modelHolder, NFCompressedGraphPointers pointers, byte[] data) {
        this.spec = spec;
        this.modelHolder = modelHolder;
        this.pointers = pointers;
        this.data = data;
    }

    public void serializeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        this.serializeSpec(dos);
        this.serializeModels(dos);
        this.serializePointers(dos);
        this.serializeData(dos);
        dos.flush();
    }

    private void serializeSpec(DataOutputStream dos) throws IOException {
        dos.writeInt(this.spec.size());
        for (NFNodeSpec nodeSpec : this.spec) {
            dos.writeUTF(nodeSpec.getNodeTypeName());
            dos.writeInt(nodeSpec.getPropertySpecs().length);
            for (NFPropertySpec propertySpec : nodeSpec.getPropertySpecs()) {
                dos.writeUTF(propertySpec.getName());
                dos.writeUTF(propertySpec.getToNodeType());
                dos.writeBoolean(propertySpec.isGlobal());
                dos.writeBoolean(propertySpec.isMultiple());
                dos.writeBoolean(propertySpec.isHashed());
            }
        }
    }

    private void serializeModels(DataOutputStream dos) throws IOException {
        dos.writeInt(this.modelHolder.size());
        for (String model : this.modelHolder) {
            dos.writeUTF(model);
        }
    }

    private void serializePointers(DataOutputStream dos) throws IOException {
        dos.writeInt(this.pointers.asMap().size());
        for (Map.Entry<String, int[]> entry : this.pointers.asMap().entrySet()) {
            dos.writeUTF(entry.getKey());
            this.serializePointerArray(dos, entry.getValue());
        }
    }

    private void serializePointerArray(DataOutputStream dos, int[] pointers) throws IOException {
        ByteArrayBuffer buf = new ByteArrayBuffer();
        int currentPointer = 0;
        for (int i = 0; i < pointers.length; ++i) {
            if (pointers[i] == -1) {
                buf.writeVInt(-1);
                continue;
            }
            buf.writeVInt(pointers[i] - currentPointer);
            currentPointer = pointers[i];
        }
        dos.writeInt(pointers.length);
        dos.writeInt(buf.length());
        buf.copyTo(dos);
    }

    private void serializeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.data.length);
        dos.write(this.data);
    }
}

