/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressor;

import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.build.NFBuildGraphNode;
import com.netflix.nfgraph.build.NFBuildGraphNodeCache;
import com.netflix.nfgraph.compressed.NFCompressedGraph;
import com.netflix.nfgraph.compressed.NFCompressedGraphPointers;
import com.netflix.nfgraph.compressor.BitSetPropertyBuilder;
import com.netflix.nfgraph.compressor.CompactPropertyBuilder;
import com.netflix.nfgraph.compressor.HashedPropertyBuilder;
import com.netflix.nfgraph.spec.NFGraphSpec;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import com.netflix.nfgraph.util.ByteArrayBuffer;
import java.util.List;

public class NFCompressedGraphBuilder {
    private final NFGraphSpec graphSpec;
    private final NFBuildGraphNodeCache buildGraphNodeCache;
    private final NFGraphModelHolder modelHolder;
    private final ByteArrayBuffer graphBuffer;
    private final ByteArrayBuffer modelBuffer;
    private final ByteArrayBuffer fieldBuffer;
    private final CompactPropertyBuilder compactPropertyBuilder;
    private final HashedPropertyBuilder hashedPropertyBuilder;
    private final BitSetPropertyBuilder bitSetPropertyBuilder;
    private NFCompressedGraphPointers compressedGraphPointers;

    public NFCompressedGraphBuilder(NFGraphSpec graphSpec, NFBuildGraphNodeCache buildGraphNodeCache, NFGraphModelHolder modelHolder) {
        this.graphSpec = graphSpec;
        this.buildGraphNodeCache = buildGraphNodeCache;
        this.modelHolder = modelHolder;
        this.graphBuffer = new ByteArrayBuffer();
        this.modelBuffer = new ByteArrayBuffer();
        this.fieldBuffer = new ByteArrayBuffer();
        this.compactPropertyBuilder = new CompactPropertyBuilder(this.fieldBuffer);
        this.hashedPropertyBuilder = new HashedPropertyBuilder(this.fieldBuffer);
        this.bitSetPropertyBuilder = new BitSetPropertyBuilder(this.fieldBuffer);
        this.compressedGraphPointers = new NFCompressedGraphPointers();
    }

    public NFCompressedGraph buildGraph() {
        for (String nodeType : this.graphSpec.getNodeTypes()) {
            List<NFBuildGraphNode> nodeOrdinals = this.buildGraphNodeCache.getNodes(nodeType);
            this.addNodeType(nodeType, nodeOrdinals);
        }
        return new NFCompressedGraph(this.graphSpec, this.modelHolder, this.graphBuffer.getData(), this.compressedGraphPointers);
    }

    private void addNodeType(String nodeType, List<NFBuildGraphNode> nodes) {
        NFNodeSpec nodeSpec = this.graphSpec.getNodeSpec(nodeType);
        int[] ordinalPointers = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            NFBuildGraphNode node = nodes.get(i);
            if (node != null) {
                ordinalPointers[i] = this.graphBuffer.length();
                this.serializeNode(node, nodeSpec);
                continue;
            }
            ordinalPointers[i] = -1;
        }
        this.compressedGraphPointers.addPointers(nodeType, ordinalPointers);
    }

    private void serializeNode(NFBuildGraphNode node, NFNodeSpec nodeSpec) {
        for (NFPropertySpec propertySpec : nodeSpec.getPropertySpecs()) {
            this.serializeProperty(node, propertySpec);
        }
    }

    private void serializeProperty(NFBuildGraphNode node, NFPropertySpec propertySpec) {
        if (propertySpec.isConnectionModelSpecific()) {
            for (int i = 0; i < this.modelHolder.size(); ++i) {
                this.serializeProperty(node, propertySpec, i, this.modelBuffer);
            }
            this.copyBuffer(this.modelBuffer, this.graphBuffer);
        } else {
            this.serializeProperty(node, propertySpec, 0, this.graphBuffer);
        }
    }

    private void serializeProperty(NFBuildGraphNode node, NFPropertySpec propertySpec, int connectionModelIndex, ByteArrayBuffer toBuffer) {
        if (propertySpec.isMultiple()) {
            this.serializeMultipleProperty(node, propertySpec, connectionModelIndex, toBuffer);
        } else {
            int connection = node.getConnection(connectionModelIndex, propertySpec);
            if (connection == -1) {
                toBuffer.writeByte((byte)-128);
            } else {
                toBuffer.writeVInt(connection);
            }
        }
    }

    private void serializeMultipleProperty(NFBuildGraphNode node, NFPropertySpec propertySpec, int connectionModelIndex, ByteArrayBuffer toBuffer) {
        OrdinalSet connections = node.getConnectionSet(connectionModelIndex, propertySpec);
        int numBitsInBitSet = this.buildGraphNodeCache.numNodes(propertySpec.getToNodeType());
        int bitSetSize = (numBitsInBitSet - 1) / 8 + 1;
        if (connections.size() < bitSetSize) {
            if (propertySpec.isHashed()) {
                this.hashedPropertyBuilder.buildProperty(connections);
                if (this.fieldBuffer.length() < bitSetSize) {
                    int log2BytesUsed = 32 - Integer.numberOfLeadingZeros(this.fieldBuffer.length());
                    toBuffer.writeByte((byte)log2BytesUsed);
                    toBuffer.write(this.fieldBuffer);
                    this.fieldBuffer.reset();
                    return;
                }
            } else {
                this.compactPropertyBuilder.buildProperty(connections);
                if (this.fieldBuffer.length() < bitSetSize) {
                    toBuffer.writeVInt(this.fieldBuffer.length());
                    toBuffer.write(this.fieldBuffer);
                    this.fieldBuffer.reset();
                    return;
                }
            }
            this.fieldBuffer.reset();
        }
        this.bitSetPropertyBuilder.buildProperty(connections, numBitsInBitSet);
        toBuffer.writeByte((byte)-128);
        toBuffer.write(this.fieldBuffer);
        this.fieldBuffer.reset();
    }

    private void copyBuffer(ByteArrayBuffer from, ByteArrayBuffer to) {
        to.writeVInt(from.length());
        to.write(from);
        from.reset();
    }
}

