/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressor;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.util.ByteArrayBuffer;
import com.netflix.nfgraph.util.Mixer;

public class HashedPropertyBuilder {
    private ByteArrayBuffer buf;

    public HashedPropertyBuilder(ByteArrayBuffer buf) {
        this.buf = buf;
    }

    public void buildProperty(OrdinalSet ordinals) {
        if (ordinals.size() == 0) {
            return;
        }
        byte[] data = this.buildHashedPropertyData(ordinals);
        this.buf.write(data);
    }

    private byte[] buildHashedPropertyData(OrdinalSet ordinals) {
        byte[] data = new byte[this.calculateByteArraySize(ordinals)];
        OrdinalIterator iter = ordinals.iterator();
        int ordinal = iter.nextOrdinal();
        while (ordinal != Integer.MAX_VALUE) {
            this.put(ordinal, data);
            ordinal = iter.nextOrdinal();
        }
        return data;
    }

    private void put(int value, byte[] data) {
        int bucket;
        if (data[bucket = Mixer.hashInt(++value) & data.length - 1] != 0) {
            bucket = this.nextEmptyByte(data, bucket);
        }
        this.writeKey(value, bucket, data);
    }

    private void writeKey(int value, int offset, byte[] data) {
        int numBytes = this.calculateVIntSize(value);
        this.ensureSpaceIsAvailable(numBytes, offset, data);
        this.writeVInt(value, offset, data, numBytes);
    }

    private void writeVInt(int value, int offset, byte[] data, int numBytes) {
        int b = value >>> 7 * (numBytes - 1) & 0x7F;
        data[offset] = (byte)b;
        offset = this.nextOffset(data.length, offset);
        for (int i = numBytes - 2; i >= 0; --i) {
            b = value >>> 7 * i & 0x7F;
            data[offset] = (byte)(b | 0x80);
            offset = this.nextOffset(data.length, offset);
        }
    }

    private int nextOffset(int length, int offset) {
        if (++offset == length) {
            offset = 0;
        }
        return offset;
    }

    private int previousOffset(int length, int offset) {
        if (--offset == -1) {
            offset = length - 1;
        }
        return offset;
    }

    private void ensureSpaceIsAvailable(int requiredSpace, int offset, byte[] data) {
        int copySpaces = 0;
        int foundSpace = 1;
        int currentOffset = offset;
        while (foundSpace < requiredSpace) {
            if (data[currentOffset = this.nextOffset(data.length, currentOffset)] == 0) {
                ++foundSpace;
                continue;
            }
            ++copySpaces;
        }
        int moveToOffset = currentOffset;
        currentOffset = this.previousOffset(data.length, currentOffset);
        while (copySpaces > 0) {
            if (data[currentOffset] != 0) {
                data[moveToOffset] = data[currentOffset];
                --copySpaces;
                moveToOffset = this.previousOffset(data.length, moveToOffset);
            }
            currentOffset = this.previousOffset(data.length, currentOffset);
        }
    }

    private int nextEmptyByte(byte[] data, int offset) {
        while (data[offset] != 0) {
            offset = this.nextOffset(data.length, offset);
        }
        return offset;
    }

    private int calculateByteArraySize(OrdinalSet ordinals) {
        int numPopulatedBytes = this.calculateNumPopulatedBytes(ordinals.iterator());
        return this.calculateByteArraySizeAfterLoadFactor(numPopulatedBytes);
    }

    private int calculateNumPopulatedBytes(OrdinalIterator ordinalIterator) {
        int totalSize = 0;
        int ordinal = ordinalIterator.nextOrdinal();
        while (ordinal != Integer.MAX_VALUE) {
            totalSize += this.calculateVIntSize(ordinal + 1);
            ordinal = ordinalIterator.nextOrdinal();
        }
        return totalSize;
    }

    private int calculateVIntSize(int value) {
        int numBitsSet = this.numBitsUsed(value);
        return (numBitsSet - 1) / 7 + 1;
    }

    private int calculateByteArraySizeAfterLoadFactor(int numPopulatedBytes) {
        int desiredSizeAfterLoadFactor = numPopulatedBytes * 4 / 3;
        int nextPowerOfTwo = 1 << this.numBitsUsed(desiredSizeAfterLoadFactor);
        return nextPowerOfTwo;
    }

    private int numBitsUsed(int value) {
        return 32 - Integer.numberOfLeadingZeros(value);
    }
}

