/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressor;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.util.ByteArrayBuffer;

public class BitSetPropertyBuilder {
    private final ByteArrayBuffer buf;

    public BitSetPropertyBuilder(ByteArrayBuffer buf) {
        this.buf = buf;
    }

    public void buildProperty(OrdinalSet ordinals, int numBits) {
        byte[] data = this.buildBitSetData(numBits, ordinals.iterator());
        this.buf.write(data);
    }

    private byte[] buildBitSetData(int numBits, OrdinalIterator iter) {
        int numBytes = (numBits - 1) / 8 + 1;
        byte[] data = new byte[numBytes];
        int ordinal = iter.nextOrdinal();
        while (ordinal != Integer.MAX_VALUE) {
            int n = ordinal >> 3;
            data[n] = (byte)(data[n] | (byte)(1 << (ordinal & 7)));
            ordinal = iter.nextOrdinal();
        }
        return data;
    }
}

