/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.NFGraph;
import com.netflix.nfgraph.NFGraphModelHolder;
import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.compressed.BitSetOrdinalIterator;
import com.netflix.nfgraph.compressed.BitSetOrdinalSet;
import com.netflix.nfgraph.compressed.CompactOrdinalIterator;
import com.netflix.nfgraph.compressed.CompactOrdinalSet;
import com.netflix.nfgraph.compressed.HashSetOrdinalIterator;
import com.netflix.nfgraph.compressed.HashSetOrdinalSet;
import com.netflix.nfgraph.compressed.NFCompressedGraphPointers;
import com.netflix.nfgraph.compressed.SingleOrdinalIterator;
import com.netflix.nfgraph.compressed.SingleOrdinalSet;
import com.netflix.nfgraph.exception.NFGraphException;
import com.netflix.nfgraph.serializer.NFCompressedGraphDeserializer;
import com.netflix.nfgraph.serializer.NFCompressedGraphSerializer;
import com.netflix.nfgraph.spec.NFGraphSpec;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import com.netflix.nfgraph.util.ByteArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NFCompressedGraph
extends NFGraph {
    private final NFCompressedGraphPointers pointers;
    private final byte[] data;

    public NFCompressedGraph(NFGraphSpec spec, NFGraphModelHolder modelHolder, byte[] data, NFCompressedGraphPointers pointers) {
        super(spec, modelHolder);
        this.data = data;
        this.pointers = pointers;
    }

    @Override
    protected int getConnection(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFPropertySpec propertySpec;
        ByteArrayReader reader = this.reader(nodeType, ordinal);
        if (reader != null && (propertySpec = this.pointReaderAtProperty(reader, nodeType, propertyName, connectionModelIndex)) != null) {
            if (propertySpec.isSingle()) {
                return reader.readVInt();
            }
            int firstOrdinal = this.iterator(nodeType, reader, propertySpec).nextOrdinal();
            if (firstOrdinal != Integer.MAX_VALUE) {
                return firstOrdinal;
            }
        }
        return -1;
    }

    @Override
    protected OrdinalSet getConnectionSet(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFPropertySpec propertySpec;
        ByteArrayReader reader = this.reader(nodeType, ordinal);
        if (reader != null && (propertySpec = this.pointReaderAtProperty(reader, nodeType, propertyName, connectionModelIndex)) != null) {
            return this.set(nodeType, reader, propertySpec);
        }
        return OrdinalSet.EMPTY_SET;
    }

    @Override
    protected OrdinalIterator getConnectionIterator(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFPropertySpec propertySpec;
        ByteArrayReader reader = this.reader(nodeType, ordinal);
        if (reader != null && (propertySpec = this.pointReaderAtProperty(reader, nodeType, propertyName, connectionModelIndex)) != null) {
            return this.iterator(nodeType, reader, propertySpec);
        }
        return OrdinalIterator.EMPTY_ITERATOR;
    }

    NFCompressedGraphPointers getPointers() {
        return this.pointers;
    }

    private OrdinalSet set(String nodeType, ByteArrayReader reader, NFPropertySpec propertySpec) {
        if (propertySpec.isSingle()) {
            return new SingleOrdinalSet(reader.readVInt());
        }
        int size = reader.readVInt();
        if (size == -1) {
            int numBits = this.pointers.numPointers(propertySpec.getToNodeType());
            int numBytes = (numBits - 1) / 8 + 1;
            reader.setRemainingBytes(numBytes);
            return new BitSetOrdinalSet(reader);
        }
        if (size == 0) {
            return OrdinalSet.EMPTY_SET;
        }
        if (propertySpec.isHashed()) {
            reader.setRemainingBytes(1 << size - 1);
            return new HashSetOrdinalSet(reader);
        }
        reader.setRemainingBytes(size);
        return new CompactOrdinalSet(reader);
    }

    private OrdinalIterator iterator(String nodeType, ByteArrayReader reader, NFPropertySpec propertySpec) {
        if (propertySpec.isSingle()) {
            return new SingleOrdinalIterator(reader.readVInt());
        }
        int size = reader.readVInt();
        if (size == -1) {
            int numBits = this.pointers.numPointers(propertySpec.getToNodeType());
            int numBytes = (numBits - 1) / 8 + 1;
            reader.setRemainingBytes(numBytes);
            return new BitSetOrdinalIterator(reader);
        }
        if (size == 0) {
            return OrdinalIterator.EMPTY_ITERATOR;
        }
        if (propertySpec.isHashed()) {
            reader.setRemainingBytes(1 << size);
            return new HashSetOrdinalIterator(reader);
        }
        reader.setRemainingBytes(size);
        return new CompactOrdinalIterator(reader);
    }

    private ByteArrayReader reader(String nodeType, int ordinal) {
        int pointer = this.pointers.getPointer(nodeType, ordinal);
        if (pointer == -1) {
            return null;
        }
        return new ByteArrayReader(this.data, pointer);
    }

    private NFPropertySpec pointReaderAtProperty(ByteArrayReader reader, String nodeType, String propertyName, int connectionModelIndex) {
        NFNodeSpec nodeSpec = this.graphSpec.getNodeSpec(nodeType);
        for (NFPropertySpec propertySpec : nodeSpec.getPropertySpecs()) {
            if (propertySpec.getName().equals(propertyName)) {
                if (propertySpec.isConnectionModelSpecific()) {
                    this.positionForModel(reader, connectionModelIndex, propertySpec);
                }
                return propertySpec;
            }
            this.skipProperty(reader, propertySpec);
        }
        throw new NFGraphException("Property " + propertyName + " is undefined for node type " + nodeType);
    }

    private void positionForModel(ByteArrayReader reader, int connectionModelIndex, NFPropertySpec propertySpec) {
        reader.setRemainingBytes(reader.readVInt());
        for (int i = 0; i < connectionModelIndex; ++i) {
            this.skipSingleProperty(reader, propertySpec);
        }
    }

    private void skipProperty(ByteArrayReader reader, NFPropertySpec propertySpec) {
        if (propertySpec.isConnectionModelSpecific()) {
            int size = reader.readVInt();
            reader.skip(size);
        } else {
            this.skipSingleProperty(reader, propertySpec);
        }
    }

    private void skipSingleProperty(ByteArrayReader reader, NFPropertySpec propertySpec) {
        if (propertySpec.isSingle()) {
            reader.readVInt();
            return;
        }
        int size = reader.readVInt();
        if (size == 0) {
            return;
        }
        if (size == -1) {
            int numBits = this.pointers.numPointers(propertySpec.getToNodeType());
            int numBytes = (numBits - 1) / 8 + 1;
            reader.skip(numBytes);
            return;
        }
        if (propertySpec.isHashed()) {
            reader.skip(1 << size - 1);
            return;
        }
        reader.skip(size);
    }

    public void writeTo(OutputStream os) throws IOException {
        NFCompressedGraphSerializer serializer = new NFCompressedGraphSerializer(this.graphSpec, this.modelHolder, this.pointers, this.data);
        serializer.serializeTo(os);
    }

    public static NFCompressedGraph readFrom(InputStream is) throws IOException {
        NFCompressedGraphDeserializer deserializer = new NFCompressedGraphDeserializer();
        return deserializer.deserialize(is);
    }
}

