/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.compressed.HashSetOrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;
import com.netflix.nfgraph.util.Mixer;

public class HashSetOrdinalSet
extends OrdinalSet {
    private final ByteArrayReader reader;
    private int size = Integer.MIN_VALUE;

    public HashSetOrdinalSet(ByteArrayReader reader) {
        this.reader = reader;
    }

    @Override
    public OrdinalIterator iterator() {
        return new HashSetOrdinalIterator(this.reader.copy());
    }

    @Override
    public boolean contains(int value) {
        int offset = Mixer.hashInt(++value) & this.reader.length() - 1;
        offset = this.seekBeginByte(offset);
        while (this.reader.getByte(offset) != 0) {
            int readValue = this.reader.getByte(offset);
            offset = this.nextOffset(offset);
            while ((this.reader.getByte(offset) & 0x80) != 0) {
                readValue <<= 7;
                readValue |= this.reader.getByte(offset) & 0x7F;
                offset = this.nextOffset(offset);
            }
            if (readValue != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        if (this.size == Integer.MIN_VALUE) {
            this.size = this.countHashEntries();
        }
        return this.size;
    }

    private int seekBeginByte(int offset) {
        while ((this.reader.getByte(offset) & 0x80) != 0) {
            offset = this.nextOffset(offset);
        }
        return offset;
    }

    private int nextOffset(int offset) {
        if (++offset >= this.reader.length()) {
            offset = 0;
        }
        return offset;
    }

    private int countHashEntries() {
        int counter = 0;
        for (int i = 0; i < this.reader.length(); ++i) {
            byte b = this.reader.getByte(i);
            if (b == 0 || (b & 0x80) != 0) continue;
            ++counter;
        }
        return counter;
    }
}

