/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.compressed.CompactOrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;
import java.util.Arrays;

public class CompactOrdinalSet
extends OrdinalSet {
    private final ByteArrayReader reader;
    private int size = Integer.MIN_VALUE;

    public CompactOrdinalSet(ByteArrayReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean contains(int value) {
        OrdinalIterator iter = this.iterator();
        int iterValue = iter.nextOrdinal();
        while (iterValue < value) {
            iterValue = iter.nextOrdinal();
        }
        return iterValue == value;
    }

    @Override
    public boolean containsAll(int ... values) {
        OrdinalIterator iter = this.iterator();
        Arrays.sort(values);
        int valuesIndex = 0;
        int setValue = iter.nextOrdinal();
        while (valuesIndex < values.length) {
            if (setValue == values[valuesIndex]) {
                ++valuesIndex;
                continue;
            }
            if (setValue >= values[valuesIndex]) break;
            setValue = iter.nextOrdinal();
        }
        return valuesIndex == values.length;
    }

    @Override
    public OrdinalIterator iterator() {
        return new CompactOrdinalIterator(this.reader.copy());
    }

    @Override
    public int size() {
        if (this.sizeIsUnknown()) {
            this.size = this.countVInts(this.reader.copy());
        }
        return this.size;
    }

    private boolean sizeIsUnknown() {
        return this.size == Integer.MIN_VALUE;
    }

    private int countVInts(ByteArrayReader myReader) {
        int counter = 0;
        while (myReader.readVInt() >= 0) {
            ++counter;
        }
        return counter;
    }
}

