/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;

public class CompactOrdinalIterator
implements OrdinalIterator {
    private final ByteArrayReader arrayReader;
    private int currentOrdinal = 0;

    CompactOrdinalIterator(ByteArrayReader arrayReader) {
        this.arrayReader = arrayReader;
    }

    @Override
    public int nextOrdinal() {
        int delta = this.arrayReader.readVInt();
        if (delta == -1) {
            return Integer.MAX_VALUE;
        }
        this.currentOrdinal += delta;
        return this.currentOrdinal;
    }

    @Override
    public void reset() {
        this.arrayReader.reset();
        this.currentOrdinal = 0;
    }

    @Override
    public OrdinalIterator copy() {
        return new CompactOrdinalIterator(this.arrayReader.copy());
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

