/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.compressed.BitSetOrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;

public class BitSetOrdinalSet
extends OrdinalSet {
    private final ByteArrayReader reader;
    private static final int[] BITS_SET_TABLE = new int[256];

    public BitSetOrdinalSet(ByteArrayReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean contains(int value) {
        int offset = value >>> 3;
        int mask = 1 << (value & 7);
        return (this.reader.getByte(offset) & mask) != 0;
    }

    @Override
    public OrdinalIterator iterator() {
        return new BitSetOrdinalIterator(this.reader);
    }

    @Override
    public int size() {
        int cardinalitySum = 0;
        for (int i = 0; i < this.reader.length(); ++i) {
            cardinalitySum += BITS_SET_TABLE[this.reader.getByte(i) & 0xFF];
        }
        return cardinalitySum;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BitSetOrdinalSet.BITS_SET_TABLE[i] = (i & 1) + BITS_SET_TABLE[i / 2];
        }
    }
}

