/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.compressed;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.util.ByteArrayReader;

public class BitSetOrdinalIterator
implements OrdinalIterator {
    private final ByteArrayReader reader;
    public int offset;

    public BitSetOrdinalIterator(ByteArrayReader reader) {
        this.reader = reader;
    }

    @Override
    public int nextOrdinal() {
        if (this.offset >>> 3 == this.reader.length()) {
            return Integer.MAX_VALUE;
        }
        this.skipToNextPopulatedByte();
        while (this.moreBytesToRead()) {
            if (this.testCurrentBit()) {
                return this.offset++;
            }
            ++this.offset;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void reset() {
        this.offset = 0;
    }

    @Override
    public OrdinalIterator copy() {
        return new BitSetOrdinalIterator(this.reader);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    private void skipToNextPopulatedByte() {
        if (this.moreBytesToRead() && this.currentByte() >>> (this.offset & 7) == 0) {
            this.offset += 8;
            this.offset &= 0xFFFFFFF8;
            while (this.moreBytesToRead() && this.currentByte() == 0) {
                this.offset += 8;
            }
        }
    }

    private boolean moreBytesToRead() {
        return this.offset >>> 3 < this.reader.length();
    }

    private boolean testCurrentBit() {
        byte b = this.currentByte();
        return (b & 1 << (this.offset & 7)) != 0;
    }

    private byte currentByte() {
        return this.reader.getByte(this.offset >>> 3);
    }
}

