/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.build.NFBuildGraphOrdinalIterator;
import java.util.Arrays;

public class NFBuildGraphOrdinalSet
extends OrdinalSet {
    private final int[] ordinals;
    private final int size;

    public NFBuildGraphOrdinalSet(int[] ordinals, int size) {
        this.ordinals = ordinals;
        this.size = size;
    }

    @Override
    public boolean contains(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.ordinals[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] asArray() {
        return Arrays.copyOf(this.ordinals, this.size);
    }

    @Override
    public OrdinalIterator iterator() {
        return new NFBuildGraphOrdinalIterator(this.ordinals, this.size);
    }

    @Override
    public int size() {
        return this.size;
    }
}

