/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.build.NFBuildGraphOrdinalIterator;
import com.netflix.nfgraph.build.NFBuildGraphOrdinalSet;
import com.netflix.nfgraph.compressed.SingleOrdinalIterator;
import com.netflix.nfgraph.compressed.SingleOrdinalSet;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import java.util.Arrays;

class NFBuildGraphNodeConnections {
    private static final int[] EMPTY_ORDINAL_ARRAY = new int[0];
    private final int[] singleValues;
    private final int[][] multipleValues;
    private final int[] multipleValueSizes;

    NFBuildGraphNodeConnections(NFNodeSpec nodeSpec) {
        this.singleValues = new int[nodeSpec.getNumSingleProperties()];
        this.multipleValues = new int[nodeSpec.getNumMultipleProperties()][];
        this.multipleValueSizes = new int[nodeSpec.getNumMultipleProperties()];
        Arrays.fill(this.singleValues, -1);
        Arrays.fill((Object[])this.multipleValues, EMPTY_ORDINAL_ARRAY);
    }

    int getConnection(NFPropertySpec spec) {
        if (spec.isSingle()) {
            return this.singleValues[spec.getPropertyIndex()];
        }
        if (this.multipleValues[spec.getPropertyIndex()].length > 0) {
            return this.multipleValues[spec.getPropertyIndex()].length;
        }
        return -1;
    }

    OrdinalSet getConnectionSet(NFPropertySpec spec) {
        if (spec.isMultiple()) {
            return new NFBuildGraphOrdinalSet(this.multipleValues[spec.getPropertyIndex()], this.multipleValueSizes[spec.getPropertyIndex()]);
        }
        return new SingleOrdinalSet(this.singleValues[spec.getPropertyIndex()]);
    }

    OrdinalIterator getConnectionIterator(NFPropertySpec spec) {
        if (spec.isMultiple()) {
            return new NFBuildGraphOrdinalIterator(this.multipleValues[spec.getPropertyIndex()], this.multipleValueSizes[spec.getPropertyIndex()]);
        }
        return new SingleOrdinalIterator(this.singleValues[spec.getPropertyIndex()]);
    }

    void addConnection(NFPropertySpec spec, int ordinal) {
        if (spec.isMultiple()) {
            this.addMultipleProperty(spec, ordinal);
        } else {
            this.singleValues[spec.getPropertyIndex()] = ordinal;
        }
    }

    void addMultipleProperty(NFPropertySpec spec, int ordinal) {
        int[] values = this.multipleValues[spec.getPropertyIndex()];
        int propSize = this.multipleValueSizes[spec.getPropertyIndex()];
        if (values.length == 0) {
            values = new int[2];
            this.multipleValues[spec.getPropertyIndex()] = values;
        } else if (values.length == propSize) {
            values = Arrays.copyOf(values, values.length * 3 / 2);
            this.multipleValues[spec.getPropertyIndex()] = values;
        }
        values[propSize] = ordinal;
        int n = spec.getPropertyIndex();
        this.multipleValueSizes[n] = this.multipleValueSizes[n] + 1;
    }
}

