/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.build.NFBuildGraphNodeConnections;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;
import java.util.Arrays;

public class NFBuildGraphNode {
    private final NFNodeSpec nodeSpec;
    private NFBuildGraphNodeConnections[] connectionModelSpecificConnections;
    private final int ordinal;
    private int numIncomingConnections;

    NFBuildGraphNode(NFNodeSpec nodeSpec, int ordinal, int numKnownConnectionModels) {
        this.nodeSpec = nodeSpec;
        this.connectionModelSpecificConnections = new NFBuildGraphNodeConnections[numKnownConnectionModels];
        this.ordinal = ordinal;
        this.numIncomingConnections = 0;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getConnection(int connectionModelIndex, NFPropertySpec spec) {
        NFBuildGraphNodeConnections connections = this.getConnections(connectionModelIndex);
        if (connections == null) {
            return -1;
        }
        return connections.getConnection(spec);
    }

    public OrdinalSet getConnectionSet(int connectionModelIndex, NFPropertySpec spec) {
        NFBuildGraphNodeConnections connections = this.getConnections(connectionModelIndex);
        if (connections == null) {
            return OrdinalSet.EMPTY_SET;
        }
        return connections.getConnectionSet(spec);
    }

    public OrdinalIterator getConnectionIterator(int connectionModelIndex, NFPropertySpec spec) {
        NFBuildGraphNodeConnections connections = this.getConnections(connectionModelIndex);
        if (connections == null) {
            return OrdinalIterator.EMPTY_ITERATOR;
        }
        return connections.getConnectionIterator(spec);
    }

    void addConnection(int connectionModelIndex, NFPropertySpec spec, int ordinal) {
        NFBuildGraphNodeConnections connections = this.getOrCreateConnections(connectionModelIndex);
        connections.addConnection(spec, ordinal);
    }

    void incrementNumIncomingConnections() {
        ++this.numIncomingConnections;
    }

    int numIncomingConnections() {
        return this.numIncomingConnections;
    }

    private NFBuildGraphNodeConnections getConnections(int connectionModelIndex) {
        if (this.connectionModelSpecificConnections.length <= connectionModelIndex) {
            return null;
        }
        return this.connectionModelSpecificConnections[connectionModelIndex];
    }

    private NFBuildGraphNodeConnections getOrCreateConnections(int connectionModelIndex) {
        if (this.connectionModelSpecificConnections.length <= connectionModelIndex) {
            this.connectionModelSpecificConnections = Arrays.copyOf(this.connectionModelSpecificConnections, connectionModelIndex + 1);
        }
        if (this.connectionModelSpecificConnections[connectionModelIndex] == null) {
            this.connectionModelSpecificConnections[connectionModelIndex] = new NFBuildGraphNodeConnections(this.nodeSpec);
        }
        return this.connectionModelSpecificConnections[connectionModelIndex];
    }
}

