/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nfgraph.build;

import com.netflix.nfgraph.NFGraph;
import com.netflix.nfgraph.OrdinalIterator;
import com.netflix.nfgraph.OrdinalSet;
import com.netflix.nfgraph.build.NFBuildGraphNode;
import com.netflix.nfgraph.build.NFBuildGraphNodeCache;
import com.netflix.nfgraph.compressed.NFCompressedGraph;
import com.netflix.nfgraph.compressor.NFCompressedGraphBuilder;
import com.netflix.nfgraph.spec.NFGraphSpec;
import com.netflix.nfgraph.spec.NFNodeSpec;
import com.netflix.nfgraph.spec.NFPropertySpec;

public class NFBuildGraph
extends NFGraph {
    private final NFBuildGraphNodeCache nodeCache;

    public NFBuildGraph(NFGraphSpec graphSpec) {
        super(graphSpec);
        this.nodeCache = new NFBuildGraphNodeCache(graphSpec, this.modelHolder);
    }

    @Override
    protected int getConnection(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFBuildGraphNode node = this.nodeCache.getNode(nodeType, ordinal);
        NFPropertySpec propertySpec = this.getPropertySpec(nodeType, propertyName);
        return node.getConnection(connectionModelIndex, propertySpec);
    }

    @Override
    protected OrdinalIterator getConnectionIterator(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFBuildGraphNode node = this.nodeCache.getNode(nodeType, ordinal);
        NFPropertySpec propertySpec = this.getPropertySpec(nodeType, propertyName);
        return node.getConnectionIterator(connectionModelIndex, propertySpec);
    }

    @Override
    protected OrdinalSet getConnectionSet(int connectionModelIndex, String nodeType, int ordinal, String propertyName) {
        NFBuildGraphNode node = this.nodeCache.getNode(nodeType, ordinal);
        NFPropertySpec propertySpec = this.getPropertySpec(nodeType, propertyName);
        return node.getConnectionSet(connectionModelIndex, propertySpec);
    }

    public void addConnection(String nodeType, int fromOrdinal, String viaProperty, int toOrdinal) {
        this.addConnection("global", nodeType, fromOrdinal, viaProperty, toOrdinal);
    }

    public void addConnection(String connectionModel, String nodeType, int fromOrdinal, String viaPropertyName, int toOrdinal) {
        NFBuildGraphNode node = this.nodeCache.getNode(nodeType, fromOrdinal);
        NFPropertySpec propertySpec = this.getPropertySpec(nodeType, viaPropertyName);
        int connectionModelIndex = this.modelHolder.getModelIndex(connectionModel);
        node.addConnection(connectionModelIndex, propertySpec, toOrdinal);
        NFBuildGraphNode toNode = this.nodeCache.getNode(propertySpec.getToNodeType(), toOrdinal);
        toNode.incrementNumIncomingConnections();
    }

    public void addConnectionModel(String connectionModel) {
        this.modelHolder.getModelIndex(connectionModel);
    }

    private NFPropertySpec getPropertySpec(String nodeType, String propertyName) {
        NFNodeSpec nodeSpec = this.graphSpec.getNodeSpec(nodeType);
        NFPropertySpec propertySpec = nodeSpec.getPropertySpec(propertyName);
        return propertySpec;
    }

    public NFCompressedGraph compress() {
        NFCompressedGraphBuilder builder = new NFCompressedGraphBuilder(this.graphSpec, this.nodeCache, this.modelHolder);
        return builder.buildGraph();
    }
}

