/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.plugins.deb;

import com.netflix.gradle.plugins.deb.Deb;
import com.netflix.gradle.plugins.deb.DebFileVisitorStrategy;
import com.netflix.gradle.plugins.deb.InstallLineGenerator;
import com.netflix.gradle.plugins.deb.MaintainerScriptsGenerator;
import com.netflix.gradle.plugins.deb.TemplateHelper;
import com.netflix.gradle.plugins.deb.control.MultiArch;
import com.netflix.gradle.plugins.deb.validation.DebTaskPropertiesValidator;
import com.netflix.gradle.plugins.packaging.AbstractPackagingCopyAction;
import com.netflix.gradle.plugins.packaging.Dependency;
import com.netflix.gradle.plugins.packaging.Directory;
import com.netflix.gradle.plugins.packaging.Link;
import com.netflix.gradle.plugins.utils.ApacheCommonsFileSystemActions;
import com.netflix.gradle.plugins.utils.DeprecationLoggerUtils;
import com.netflix.gradle.plugins.utils.FilePermissionUtil;
import com.netflix.gradle.plugins.utils.GradleUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.FormatHelper;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vafer.jdeb.Compression;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.DebMaker;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.mapping.PermMapper;
import org.vafer.jdeb.producers.DataProducerLink;
import org.vafer.jdeb.producers.DataProducerPathTemplate;

public class DebCopyAction
extends AbstractPackagingCopyAction<Deb> {
    private static final Logger logger;
    private File debianDir;
    private List<String> dependencies;
    private List<String> conflicts;
    private List<String> recommends;
    private List<String> suggests;
    private List<String> enhances;
    private List<String> preDepends;
    private List<String> breaks;
    private List<String> replaces;
    private List<String> provides;
    private List<DataProducer> dataProducers;
    private List<InstallDir> installDirs;
    private final DebTaskPropertiesValidator debTaskPropertiesValidator;
    private DebFileVisitorStrategy debFileVisitorStrategy;
    private final MaintainerScriptsGenerator maintainerScriptsGenerator;
    private final InstallLineGenerator installLineGenerator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DebCopyAction(Deb debTask, File debianDir) {
        super(debTask);
        InstallLineGenerator installLineGenerator;
        MaintainerScriptsGenerator maintainerScriptsGenerator;
        DebFileVisitorStrategy debFileVisitorStrategy;
        File file;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        List list7;
        List list8;
        List list9;
        List list10;
        List list11;
        DebTaskPropertiesValidator debTaskPropertiesValidator;
        this.debTaskPropertiesValidator = debTaskPropertiesValidator = new DebTaskPropertiesValidator();
        this.debTaskPropertiesValidator.validate(debTask);
        this.dependencies = list11 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.conflicts = list10 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.recommends = list9 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.suggests = list8 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.enhances = list7 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.preDepends = list6 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.breaks = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.replaces = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.dataProducers = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.installDirs = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.provides = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.debianDir = file = debianDir;
        this.debFileVisitorStrategy = debFileVisitorStrategy = new DebFileVisitorStrategy(this.dataProducers, this.installDirs);
        this.maintainerScriptsGenerator = maintainerScriptsGenerator = new MaintainerScriptsGenerator(debTask, new TemplateHelper(debianDir, "/deb"), debianDir, new ApacheCommonsFileSystemActions());
        this.installLineGenerator = installLineGenerator = new InstallLineGenerator();
    }

    @Override
    public void startVisit(CopyAction action) {
        super.startVisit(action);
        ResourceGroovyMethods.deleteDir((File)this.debianDir);
        this.debianDir.mkdirs();
    }

    @Override
    public void visitFile(FileCopyDetailsInternal fileDetails, Object specToLookAt) {
        Integer n;
        Integer n2;
        Object t;
        logger.debug("adding file {}", (Object)fileDetails.getRelativePath().getPathString());
        File inputFile = this.extractFile(fileDetails);
        CallSite fileType = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "fileType"));
        if (ScriptBytecodeAdapter.compareEqual((Object)fileType, (Object)"CONFIG")) {
            logger.debug("mark {} as configuration file", (Object)fileDetails.getRelativePath().getPathString());
            ((Deb)((Object)this.getTask())).configurationFile(fileDetails.getRelativePath().getPathString());
        }
        CallSite user = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, t = GradleUtils.lookup(specToLookAt, "user")) != false ? t : ((Deb)((Object)this.getTask())).getUser());
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "uid"));
        CallSite uid = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : (IndyInterface.bootstrap("cast", "()", 0, n2 = ((Deb)((Object)this.getTask())).getUid()) != false ? n2 : Integer.valueOf(0));
        Object t2 = GradleUtils.lookup(specToLookAt, "permissionGroup");
        CallSite group = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, t2) != false ? t2 : ((Deb)((Object)this.getTask())).getPermissionGroup());
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "gid"));
        CallSite gid = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : (IndyInterface.bootstrap("cast", "()", 0, n = ((Deb)((Object)this.getTask())).getGid()) != false ? n : Integer.valueOf(0));
        Integer explicitMode = FilePermissionUtil.getFileMode(specToLookAt);
        int workaroundMode = FilePermissionUtil.getUnixPermission((FileCopyDetails)fileDetails);
        logger.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{fileDetails.getRelativePath().getPathString(), explicitMode, workaroundMode}, new String[]{"File: ", ", explicitMode: ", ", workaroundMode: ", ""}))));
        int fileMode = 0;
        if (explicitMode != null) {
            fileMode = explicitMode;
            logger.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{explicitMode}, new String[]{"Using explicit permissions: ", ""}))));
        } else {
            fileMode = workaroundMode;
            logger.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{workaroundMode}, new String[]{"No explicit permissions, using workaround: ", ""}))));
        }
        this.debFileVisitorStrategy.addFile((FileCopyDetails)fileDetails, inputFile, (String)((Object)user), (Integer)((Object)uid), (String)((Object)group), (Integer)((Object)gid), fileMode);
    }

    @Override
    public void visitDir(FileCopyDetailsInternal dirDetails, Object specToLookAt) {
        Object specCreateDirectoryEntry = GradleUtils.lookup(specToLookAt, "createDirectoryEntry");
        boolean createDirectoryEntry = DefaultTypeTransformation.booleanUnbox(specCreateDirectoryEntry != null ? specCreateDirectoryEntry : ((Deb)((Object)this.getTask())).getCreateDirectoryEntry());
        if (createDirectoryEntry) {
            Integer n;
            Integer n2;
            logger.debug("adding directory {}", (Object)dirDetails.getRelativePath().getPathString());
            Object t = GradleUtils.lookup(specToLookAt, "user");
            CallSite user = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, t) != false ? t : ((Deb)((Object)this.getTask())).getUser());
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "uid"));
            CallSite uid = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : (IndyInterface.bootstrap("cast", "()", 0, n2 = ((Deb)((Object)this.getTask())).getUid()) != false ? n2 : Integer.valueOf(0));
            Object t2 = GradleUtils.lookup(specToLookAt, "permissionGroup");
            CallSite group = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, t2) != false ? t2 : ((Deb)((Object)this.getTask())).getPermissionGroup());
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "gid"));
            CallSite gid = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : (IndyInterface.bootstrap("cast", "()", 0, n = ((Deb)((Object)this.getTask())).getGid()) != false ? n : Integer.valueOf(0));
            Object setgid = IndyInterface.bootstrap("cast", "()", 0, GradleUtils.lookup(specToLookAt, "setgid"));
            Integer explicitDirMode = FilePermissionUtil.getDirMode(specToLookAt);
            int dirMode = explicitDirMode != null ? explicitDirMode : Integer.valueOf(FilePermissionUtil.getUnixPermission((FileCopyDetails)dirDetails));
            if (setgid == null) {
                setgid = ((Deb)((Object)this.getTask())).getSetgid();
            }
            CallSite callSite3 = setgid;
            if (callSite3 == null ? false : (Boolean)((Object)callSite3)) {
                dirMode = dirMode | 0x400;
            }
            this.debFileVisitorStrategy.addDirectory((FileCopyDetails)dirDetails, (String)((Object)user), (Integer)((Object)uid), (String)((Object)group), (Integer)((Object)gid), dirMode);
        }
    }

    @Override
    protected void addLink(Link link) {
        DefaultGroovyMethods.leftShift(this.dataProducers, (Object)new DataProducerLink(link.getPath(), link.getTarget(), true, null, null, null));
    }

    @Override
    protected void addDependency(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.dependencies, (Object)dep.toDebString());
    }

    @Override
    protected void addConflict(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.conflicts, (Object)dep.toDebString());
    }

    @Override
    protected void addProvides(Dependency dep) {
        String providesString = dep.getPackageName();
        String string = dep.getVersion();
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            providesString = StringGroovyMethods.plus((String)providesString, (CharSequence)new GStringImpl(new Object[]{dep.getVersion()}, new String[]{" (= ", ")"}));
        }
        DefaultGroovyMethods.leftShift(this.provides, (Object)providesString);
    }

    @Override
    protected void addObsolete(Dependency dep) {
        logger.warn("Obsoletes functionality not implemented for deb files");
    }

    protected void addRecommends(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.recommends, (Object)dep.toDebString());
    }

    protected void addSuggests(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.suggests, (Object)dep.toDebString());
    }

    protected void addEnhances(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.enhances, (Object)dep.toDebString());
    }

    protected void addPreDepends(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.preDepends, (Object)dep.toDebString());
    }

    protected void addBreaks(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.breaks, (Object)dep.toDebString());
    }

    protected void addReplaces(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.replaces, (Object)dep.toDebString());
    }

    @Override
    protected void addDirectory(Directory directory) {
        String string = directory.getUser();
        String user = (string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false ? directory.getUser() : ((Deb)((Object)this.getTask())).getUser();
        String string2 = directory.getPermissionGroup();
        String permissionGroup = (string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false ? directory.getPermissionGroup() : ((Deb)((Object)this.getTask())).getPermissionGroup();
        DefaultGroovyMethods.leftShift(this.dataProducers, (Object)new DataProducerPathTemplate(new String[]{directory.getPath()}, null, null, new Mapper[]{new PermMapper(-1, -1, user, permissionGroup, directory.getPermissions(), -1, 0, null)}));
    }

    protected String getMultiArch() {
        String archString = ((Deb)((Object)this.getTask())).getArchString();
        MultiArch multiArch = ((Deb)((Object)this.getTask())).getMultiArch();
        if (ScriptBytecodeAdapter.compareEqual((Object)"all", (Object)archString) && ScriptBytecodeAdapter.compareEqual((Object)((Object)MultiArch.SAME), (Object)((Object)multiArch))) {
            throw (Throwable)new IllegalArgumentException("Deb packages with Architecture: all cannot declare Multi-Arch: same");
        }
        MultiArch multiArch2 = multiArch;
        String string = multiArch2 != null ? multiArch2.name() : null;
        String string2 = string != null ? string.toLowerCase() : null;
        String multiArchString = IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : "";
        return multiArchString;
    }

    protected Map<String, String> getCustomFields() {
        public final class _getCustomFields_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getCustomFields_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<String> doCall(String key, String val) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{StringGroovyMethods.plus((String)"XB-", (CharSequence)StringGroovyMethods.capitalize((CharSequence)key)), val});
            }

            @Generated
            public List<String> call(String key, String val) {
                return this.doCall(key, val);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCustomFields_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.collectEntries(((Deb)((Object)this.getTask())).getAllCustomFields(), (Closure)new _getCustomFields_closure1(this, this));
    }

    @Override
    protected void end() {
        List<Dependency> list;
        List<Dependency> list2;
        List<Dependency> list3;
        List<Dependency> list4;
        List<Dependency> list5;
        List<Dependency> list6 = ((Deb)((Object)this.getTask())).getAllRecommends();
        Iterator<Dependency> iterator = list6 != null ? list6.iterator() : null;
        CallSite recommends = null;
        Iterator<Dependency> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                recommends = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                logger.debug("adding recommends on {} {}", (Object)((Dependency)((Object)recommends)).getPackageName(), (Object)((Dependency)((Object)recommends)).getVersion());
                this.addRecommends((Dependency)((Object)recommends));
            }
        }
        Iterator<Dependency> iterator3 = (list5 = ((Deb)((Object)this.getTask())).getAllSuggests()) != null ? list5.iterator() : null;
        CallSite suggests = null;
        Iterator<Dependency> iterator4 = iterator3;
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                suggests = IndyInterface.bootstrap("cast", "()", 0, iterator4.next());
                logger.debug("adding suggests on {} {}", (Object)((Dependency)((Object)suggests)).getPackageName(), (Object)((Dependency)((Object)suggests)).getVersion());
                this.addSuggests((Dependency)((Object)suggests));
            }
        }
        Iterator<Dependency> iterator5 = (list4 = ((Deb)((Object)this.getTask())).getAllEnhances()) != null ? list4.iterator() : null;
        CallSite enhances = null;
        Iterator<Dependency> iterator6 = iterator5;
        if (iterator6 != null) {
            while (iterator6.hasNext()) {
                enhances = IndyInterface.bootstrap("cast", "()", 0, iterator6.next());
                logger.debug("adding enhances on {} {}", (Object)((Dependency)((Object)enhances)).getPackageName(), (Object)((Dependency)((Object)enhances)).getVersion());
                this.addEnhances((Dependency)((Object)enhances));
            }
        }
        Iterator<Dependency> iterator7 = (list3 = ((Deb)((Object)this.getTask())).getAllPreDepends()) != null ? list3.iterator() : null;
        CallSite preDepends = null;
        Iterator<Dependency> iterator8 = iterator7;
        if (iterator8 != null) {
            while (iterator8.hasNext()) {
                preDepends = IndyInterface.bootstrap("cast", "()", 0, iterator8.next());
                logger.debug("adding preDepends on {} {}", (Object)((Dependency)((Object)preDepends)).getPackageName(), (Object)((Dependency)((Object)preDepends)).getVersion());
                this.addPreDepends((Dependency)((Object)preDepends));
            }
        }
        Iterator<Dependency> iterator9 = (list2 = ((Deb)((Object)this.getTask())).getAllBreaks()) != null ? list2.iterator() : null;
        CallSite breaks = null;
        Iterator<Dependency> iterator10 = iterator9;
        if (iterator10 != null) {
            while (iterator10.hasNext()) {
                breaks = IndyInterface.bootstrap("cast", "()", 0, iterator10.next());
                logger.debug("adding breaks on {} {}", (Object)((Dependency)((Object)breaks)).getPackageName(), (Object)((Dependency)((Object)breaks)).getVersion());
                this.addBreaks((Dependency)((Object)breaks));
            }
        }
        Iterator<Dependency> iterator11 = (list = ((Deb)((Object)this.getTask())).getAllReplaces()) != null ? list.iterator() : null;
        CallSite replaces = null;
        Iterator<Dependency> iterator12 = iterator11;
        if (iterator12 != null) {
            while (iterator12.hasNext()) {
                replaces = IndyInterface.bootstrap("cast", "()", 0, iterator12.next());
                logger.debug("adding replaces on {} {}", (Object)((Dependency)((Object)replaces)).getPackageName(), (Object)((Dependency)((Object)replaces)).getVersion());
                this.addReplaces((Dependency)((Object)replaces));
            }
        }
        this.maintainerScriptsGenerator.generate(this.toContext());
        public final class _end_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _end_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public byte[] doCall(Object supControl) {
                File supControlFile = supControl instanceof File ? (File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, supControl, File.class)) : ((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getProject().file(supControl);
                byte[] byArray = ResourceGroovyMethods.getBytes((File)supControlFile);
                ResourceGroovyMethods.setBytes((File)new File(((DebCopyAction)this.getThisObject()).getDebianDir(), supControlFile.getName()), (byte[])byArray);
                return byArray;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _end_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each(((Deb)((Object)this.getTask())).getAllSupplementaryControlFiles(), (Closure)new _end_closure2(this, this));
        DebMaker maker = new DebMaker((Console)new GradleLoggerConsole(), this.dataProducers, null);
        File debFile = ((RegularFile)((Deb)((Object)this.getTask())).getArchiveFile().get()).getAsFile();
        maker.setControl(this.debianDir);
        maker.setDeb(debFile);
        if (StringUtils.isNotBlank((CharSequence)((Deb)((Object)this.getTask())).getSigningKeyId()) && StringUtils.isNotBlank((CharSequence)((Deb)((Object)this.getTask())).getSigningKeyPassphrase()) && ((Deb)((Object)this.getTask())).getSigningKeyRingFile().exists()) {
            maker.setKey(((Deb)((Object)this.getTask())).getSigningKeyId());
            maker.setPassphrase(((Deb)((Object)this.getTask())).getSigningKeyPassphrase());
            maker.setKeyring(((Deb)((Object)this.getTask())).getSigningKeyRingFile());
            maker.setSignPackage(true);
        }
        try {
            logger.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{debFile}, new String[]{"Creating debian package: ", ""}))));
            maker.setCompression(Compression.GZIP.toString());
            maker.makeDeb();
        }
        catch (Exception e) {
            throw (Throwable)new GradleException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{debFile}, new String[]{"Can't build debian package ", ""}))), (Throwable)e);
        }
        logger.info("Created deb {}", (Object)debFile);
    }

    public Map toContext() {
        String string;
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _toContext_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toContext_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public LinkedHashMap<String, String> doCall(InstallDir dir) {
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"install", ((DebCopyAction)this.getThisObject()).installLineGenerator.generate(dir)}));
            }

            @Generated
            public LinkedHashMap<String, String> call(InstallDir dir) {
                return this.doCall(dir);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toContext_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        context = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ((Deb)((Object)this.getTask())).getPackageName(), "version", ((Deb)((Object)this.getTask())).getArchiveVersion().get(), "release", ((Deb)((Object)this.getTask())).getRelease(), "maintainer", ((Deb)((Object)this.getTask())).getMaintainer(), "uploaders", ((Deb)((Object)this.getTask())).getUploaders(), "priority", ((Deb)((Object)this.getTask())).getPriority(), "epoch", ((Deb)((Object)this.getTask())).getEpoch(), "description", IndyInterface.bootstrap("cast", "()", 0, string = ((Deb)((Object)this.getTask())).getPackageDescription()) != false ? string : "", "distribution", ((Deb)((Object)this.getTask())).getDistribution(), "summary", ((Deb)((Object)this.getTask())).getSummary(), "section", ((Deb)((Object)this.getTask())).getPackageGroup(), "time", DateFormatUtils.SMTP_DATETIME_FORMAT.format(new Date()), "provides", StringUtils.join(this.provides, (String)", "), "depends", StringUtils.join(this.dependencies, (String)", "), "url", ((Deb)((Object)this.getTask())).getUrl(), "arch", ((Deb)((Object)this.getTask())).getArchString(), "multiArch", this.getMultiArch(), "conflicts", StringUtils.join(this.conflicts, (String)", "), "recommends", StringUtils.join(this.recommends, (String)", "), "suggests", StringUtils.join(this.suggests, (String)", "), "enhances", StringUtils.join(this.enhances, (String)", "), "preDepends", StringUtils.join(this.preDepends, (String)", "), "breaks", StringUtils.join(this.breaks, (String)", "), "replaces", StringUtils.join(this.replaces, (String)", "), "fullVersion", this.buildFullVersion(), "customFields", this.getCustomFields(), "dirs", DefaultGroovyMethods.collect(this.installDirs, (Closure)new _toContext_closure3(this, this))}));
        return context;
    }

    private String buildFullVersion() {
        Reference fullVersion = new Reference((Object)new StringBuilder());
        public final class _buildFullVersion_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fullVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildFullVersion_closure4(Object _outerInstance, Object _thisObject, Reference fullVersion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fullVersion = reference = fullVersion;
            }

            public StringBuilder doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getEpoch(), (Object)0)) {
                    StringBuilder stringBuilder = StringGroovyMethods.leftShift((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get())), (Object)((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getEpoch());
                    this.fullVersion.set((Object)stringBuilder);
                    StringBuilder stringBuilder2 = StringGroovyMethods.leftShift((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get())), (Object)":");
                    this.fullVersion.set((Object)stringBuilder2);
                }
                StringBuilder stringBuilder = StringGroovyMethods.leftShift((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get())), (Object)((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getVersion());
                this.fullVersion.set((Object)stringBuilder);
                String string = ((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getRelease();
                if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
                    StringBuilder stringBuilder3 = StringGroovyMethods.leftShift((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get())), (Object)"-");
                    this.fullVersion.set((Object)stringBuilder3);
                    StringBuilder stringBuilder4 = StringGroovyMethods.leftShift((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get())), (Object)((Deb)((Object)((DebCopyAction)this.getThisObject()).getTask())).getRelease());
                    this.fullVersion.set((Object)stringBuilder4);
                    return stringBuilder4;
                }
                return null;
            }

            @Generated
            public StringBuilder getFullVersion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.fullVersion.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public StringBuilder doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildFullVersion_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DeprecationLoggerUtils.whileDisabled((Runnable)((Object)new _buildFullVersion_closure4(this, this, fullVersion)));
        return ((StringBuilder)fullVersion.get()).toString();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DebCopyAction.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DebCopyAction.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ Logger pfaccess$0(DebCopyAction $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(DebCopyAction.class, DebCopyAction.class, (String)"logger"));
    }

    public static /* synthetic */ File pfaccess$1(DebCopyAction $that) {
        return $that.debianDir;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DebCopyAction.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        DebCopyAction.logger = logger = LoggerFactory.getLogger(DebCopyAction.class);
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public File getDebianDir() {
        return this.debianDir;
    }

    @Generated
    public void setDebianDir(File file) {
        this.debianDir = file;
    }

    @Generated
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setDependencies(List<String> list) {
        this.dependencies = list;
    }

    @Generated
    public List<String> getConflicts() {
        return this.conflicts;
    }

    @Generated
    public void setConflicts(List<String> list) {
        this.conflicts = list;
    }

    @Generated
    public List<String> getRecommends() {
        return this.recommends;
    }

    @Generated
    public void setRecommends(List<String> list) {
        this.recommends = list;
    }

    @Generated
    public List<String> getSuggests() {
        return this.suggests;
    }

    @Generated
    public void setSuggests(List<String> list) {
        this.suggests = list;
    }

    @Generated
    public List<String> getEnhances() {
        return this.enhances;
    }

    @Generated
    public void setEnhances(List<String> list) {
        this.enhances = list;
    }

    @Generated
    public List<String> getPreDepends() {
        return this.preDepends;
    }

    @Generated
    public void setPreDepends(List<String> list) {
        this.preDepends = list;
    }

    @Generated
    public List<String> getBreaks() {
        return this.breaks;
    }

    @Generated
    public void setBreaks(List<String> list) {
        this.breaks = list;
    }

    @Generated
    public List<String> getReplaces() {
        return this.replaces;
    }

    @Generated
    public void setReplaces(List<String> list) {
        this.replaces = list;
    }

    @Generated
    public List<String> getProvides() {
        return this.provides;
    }

    @Generated
    public void setProvides(List<String> list) {
        this.provides = list;
    }

    @Generated
    public List<DataProducer> getDataProducers() {
        return this.dataProducers;
    }

    @Generated
    public void setDataProducers(List<DataProducer> list) {
        this.dataProducers = list;
    }

    @Generated
    public List<InstallDir> getInstallDirs() {
        return this.installDirs;
    }

    @Generated
    public void setInstallDirs(List<InstallDir> list) {
        this.installDirs = list;
    }

    @ToString
    @EqualsAndHashCode
    public static class InstallDir
    implements GroovyObject {
        private String name;
        private String user;
        private String group;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public InstallDir(String name, String user, String group) {
            String string;
            String string2;
            String string3;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string3 = name;
            this.user = string2 = user;
            this.group = string = group;
        }

        @Generated
        public InstallDir(String name, String user) {
            this(name, user, null);
        }

        @Generated
        public InstallDir(String name) {
            this(name, null, null);
        }

        @Generated
        public InstallDir() {
            this(null, null, null);
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.netflix.gradle.plugins.deb.DebCopyAction$InstallDir(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(FormatHelper.toString((Object)this.getName()));
            Boolean bl2 = $toStringFirst;
            if (bl2 == null ? false : bl2) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(FormatHelper.toString((Object)this.getUser()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(FormatHelper.toString((Object)this.getGroup()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (this.getName() != this) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getName());
            }
            if (this.getUser() != this) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getUser());
            }
            if (this.getGroup() != this) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getGroup());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof InstallDir;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstallDir)) {
                return false;
            }
            InstallDir otherTyped = (InstallDir)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getName(), (Object)otherTyped.getName())) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getUser(), (Object)otherTyped.getUser())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getGroup(), (Object)otherTyped.getGroup()));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), InstallDir.class, notFound.getArguments());
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), InstallDir.class, notFound.getCause());
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(InstallDir.class, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(InstallDir.class, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), InstallDir.class, notFound.getCause());
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != InstallDir.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public void setUser(String string) {
            this.user = string;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public void setGroup(String string) {
            this.group = string;
        }
    }

    private static class GradleLoggerConsole
    implements Console,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public GradleLoggerConsole() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void debug(String message) {
            DebCopyAction.getLogger().debug(message);
        }

        public void info(String message) {
            DebCopyAction.getLogger().info(message);
        }

        public void warn(String message) {
            DebCopyAction.getLogger().warn(message);
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), GradleLoggerConsole.class, notFound.getArguments());
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), GradleLoggerConsole.class, notFound.getCause());
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GradleLoggerConsole.class, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GradleLoggerConsole.class, DebCopyAction.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), GradleLoggerConsole.class, notFound.getCause());
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GradleLoggerConsole.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

