/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IBuffer;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.ILocalVariable;
import com.netflix.nebula.lint.jdt.core.IOpenable;
import com.netflix.nebula.lint.jdt.core.ISourceRange;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.SourceRange;
import com.netflix.nebula.lint.jdt.internal.core.SourceRefElement;
import com.netflix.nebula.lint.jdt.internal.core.util.MementoTokenizer;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalVariable
extends SourceRefElement
implements ILocalVariable {
    String name;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int nameStart;
    public int nameEnd;
    String typeSignature;

    public LocalVariable(JavaElement parent, String name, int declarationSourceStart, int declarationSourceEnd, int nameStart, int nameEnd, String typeSignature) {
        super(parent);
        this.name = name;
        this.declarationSourceStart = declarationSourceStart;
        this.declarationSourceEnd = declarationSourceEnd;
        this.nameStart = nameStart;
        this.nameEnd = nameEnd;
        this.typeSignature = typeSignature;
    }

    protected void closing(Object info) {
    }

    protected Object createElementInfo() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)o;
        return this.declarationSourceStart == other.declarationSourceStart && this.declarationSourceEnd == other.declarationSourceEnd && this.nameStart == other.nameStart && this.nameEnd == other.nameEnd && super.equals(o);
    }

    public boolean exists() {
        return this.parent.exists();
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) {
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
        }
        return this;
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.name);
        buff.append('!');
        buff.append(this.declarationSourceStart);
        buff.append('!');
        buff.append(this.declarationSourceEnd);
        buff.append('!');
        buff.append(this.nameStart);
        buff.append('!');
        buff.append(this.nameEnd);
        buff.append('!');
        buff.append(this.typeSignature);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '@';
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 14;
    }

    public ISourceRange getNameRange() {
        return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
    }

    public IPath getPath() {
        return this.parent.getPath();
    }

    public IResource getResource() {
        return this.parent.getResource();
    }

    public String getSource() throws JavaModelException {
        IOpenable openable = this.parent.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() {
        return new SourceRange(this.declarationSourceStart, this.declarationSourceEnd - this.declarationSourceStart + 1);
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        return this.parent.getUnderlyingResource();
    }

    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.nameStart);
    }

    public boolean isStructureKnown() throws JavaModelException {
        return true;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info != NO_INFO) {
            buffer.append(Signature.toString(this.getTypeSignature()));
            buffer.append(" ");
        }
        this.toStringName(buffer);
    }
}

