/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NumberLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class CharLiteral
extends NumberLiteral {
    char value;

    public CharLiteral(char[] token, int s, int e) {
        super(token, s, e);
        this.computeValue();
    }

    public void computeConstant() {
        this.constant = Constant.fromValue(this.value);
    }

    private void computeValue() {
        this.value = this.source[1];
        if (this.value != '\\') {
            return;
        }
        char digit = this.source[2];
        switch (digit) {
            case 'b': {
                this.value = (char)8;
                break;
            }
            case 't': {
                this.value = (char)9;
                break;
            }
            case 'n': {
                this.value = (char)10;
                break;
            }
            case 'f': {
                this.value = (char)12;
                break;
            }
            case 'r': {
                this.value = (char)13;
                break;
            }
            case '\"': {
                this.value = (char)34;
                break;
            }
            case '\'': {
                this.value = (char)39;
                break;
            }
            case '\\': {
                this.value = (char)92;
                break;
            }
            default: {
                int number = Character.getNumericValue(digit);
                digit = this.source[3];
                if (digit == '\'') {
                    this.value = (char)number;
                    this.constant = Constant.fromValue(this.value);
                    break;
                }
                number = number * 8 + Character.getNumericValue(digit);
                digit = this.source[4];
                if (digit != '\'') {
                    number = number * 8 + Character.getNumericValue(digit);
                }
                this.value = (char)number;
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return CharBinding;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

