/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.util.concurrent.CopyOnWriteArrayList;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import netflix.karyon.transport.http.RegexUriConstraintKey;
import netflix.karyon.transport.http.ServletStyleUriConstraintKey;
import netflix.karyon.transport.interceptor.InterceptorKey;
import rx.Observable;

public class SimpleUriRouter<I, O>
implements RequestHandler<I, O> {
    private final CopyOnWriteArrayList<Route> routes = new CopyOnWriteArrayList();

    public Observable<Void> handle(HttpServerRequest<I> request, HttpServerResponse<O> response) {
        HttpKeyEvaluationContext context = new HttpKeyEvaluationContext(response.getChannel());
        for (Route route : this.routes) {
            if (!route.key.apply(request, context)) continue;
            return route.getHandler().handle(request, response);
        }
        response.setStatus(HttpResponseStatus.NOT_FOUND);
        return response.close();
    }

    public SimpleUriRouter<I, O> addUri(String uri, RequestHandler<I, O> handler) {
        this.routes.add(new Route(new ServletStyleUriConstraintKey(uri, ""), handler));
        return this;
    }

    public SimpleUriRouter<I, O> addUriRegex(String uriRegEx, RequestHandler<I, O> handler) {
        this.routes.add(new Route(new RegexUriConstraintKey(uriRegEx), handler));
        return this;
    }

    private class Route {
        private final InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key;
        private final RequestHandler<I, O> handler;

        public Route(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key, RequestHandler<I, O> handler) {
            this.key = key;
            this.handler = handler;
        }

        public InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> getKey() {
            return this.key;
        }

        public RequestHandler<I, O> getHandler() {
            return this.handler;
        }
    }
}

