/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import netflix.karyon.transport.http.HttpInterceptorKey;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletStyleUriConstraintKey<I>
implements HttpInterceptorKey<I> {
    private static final Logger logger = LoggerFactory.getLogger(ServletStyleUriConstraintKey.class);
    private final Matcher matcher;
    private final String contextPath;

    public ServletStyleUriConstraintKey(String constraint, String contextPath) {
        if (null == constraint) {
            throw new NullPointerException("Constraint can not be null.");
        }
        this.contextPath = contextPath.startsWith("/") ? contextPath : '/' + contextPath;
        String normalizedConstraint = constraint;
        if (!constraint.startsWith("/")) {
            normalizedConstraint = '/' + constraint;
        }
        this.matcher = normalizedConstraint.startsWith("/*.") ? new ExtensionMatcher(constraint) : (normalizedConstraint.endsWith("/*") ? new PrefixMatcher(normalizedConstraint.substring(0, normalizedConstraint.length() - 1), new Matcher(normalizedConstraint.substring(0, normalizedConstraint.length() - 2), null)) : (normalizedConstraint.endsWith("*") ? new PrefixMatcher(normalizedConstraint.substring(0, normalizedConstraint.length() - 1), null) : new Matcher(normalizedConstraint, new Matcher(normalizedConstraint + '/', null))));
    }

    public String getServletPath(HttpServerRequest<I> request, HttpKeyEvaluationContext context) {
        String requestUriPath = context.getRequestUriPath(request);
        if (null != requestUriPath) {
            return this.matcher.getServletPath(requestUriPath);
        }
        return "";
    }

    @Override
    public boolean apply(HttpServerRequest<I> request, HttpKeyEvaluationContext context) {
        String requestUriPath = context.getRequestUriPath(request);
        boolean matches = false;
        if (null != requestUriPath) {
            matches = this.matcher.match(requestUriPath);
        }
        return matches;
    }

    public String toString() {
        return "ServletStyleUriConstraintKey{matcher=" + this.matcher + '}';
    }

    private class ExtensionMatcher
    extends Matcher {
        private ExtensionMatcher(String constraint) {
            super(constraint.substring(1), null);
        }

        @Override
        protected boolean isMatching(String requestUriPath, boolean noLog) {
            boolean matches = requestUriPath.contains(this.constraint);
            if (!noLog && logger.isDebugEnabled()) {
                logger.debug("Extension match result for servlet style uri constraint for uri path {} and constraint {} : {}", new Object[]{requestUriPath, this.constraint, matches});
            }
            return matches;
        }

        @Override
        public String getServletPath(String requestUriPath) {
            if (this.isMatching(requestUriPath, true)) {
                return "";
            }
            return super.getServletPath(requestUriPath);
        }
    }

    private class PrefixMatcher
    extends Matcher {
        private PrefixMatcher(String prefix, Matcher nextMatcher) {
            super(prefix, nextMatcher);
        }

        @Override
        protected boolean isMatching(String requestUriPath, boolean noLog) {
            boolean matches = requestUriPath.startsWith(this.constraint);
            if (!noLog && logger.isDebugEnabled()) {
                logger.debug("Prefix match result for servlet style uri constraint for uri path {} and constraint {} : {}", new Object[]{requestUriPath, this.constraint, matches});
            }
            return matches;
        }

        @Override
        public String getServletPath(String requestUriPath) {
            if (this.isMatching(requestUriPath, true)) {
                return this.constraintWithoutContextPath.substring(0, this.constraintWithoutContextPath.length() - 1);
            }
            return super.getServletPath(requestUriPath);
        }
    }

    private class Matcher {
        protected final String constraint;
        protected final String constraintWithoutContextPath;
        private final Matcher nextMatcher;

        private Matcher(String constraint, Matcher nextMatcher) {
            this.constraint = constraint;
            this.constraintWithoutContextPath = constraint.isEmpty() ? constraint : constraint.substring(ServletStyleUriConstraintKey.this.contextPath.length());
            this.nextMatcher = nextMatcher;
        }

        protected boolean match(String requestUriPath) {
            return this.isMatching(requestUriPath, false) || null != this.nextMatcher && this.nextMatcher.match(requestUriPath);
        }

        protected boolean isMatching(String requestUriPath, boolean noLog) {
            boolean matches = requestUriPath.equals(this.constraint);
            if (!noLog && logger.isDebugEnabled()) {
                logger.debug("Exact match result for servlet style uri constraint for uri path {} and constraint {} : {}", new Object[]{requestUriPath, this.constraint, matches});
            }
            return matches;
        }

        public String getServletPath(String requestUriPath) {
            if (requestUriPath.equals(this.constraint)) {
                return this.constraintWithoutContextPath;
            }
            return null != this.nextMatcher ? this.nextMatcher.getServletPath(requestUriPath) : "";
        }

        public String toString() {
            return "Matcher{constraint='" + this.constraint + '\'' + ", nextMatcher=" + this.nextMatcher + '}';
        }
    }
}

