/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import netflix.karyon.transport.http.HttpInterceptorSupport;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import netflix.karyon.transport.http.HttpRequestHandler;
import netflix.karyon.transport.interceptor.InterceptorKey;

public class HttpRequestHandlerBuilder<I, O> {
    private final HttpInterceptorSupport<I, O> interceptorSupport;
    private final RequestHandler<I, O> router;

    public HttpRequestHandlerBuilder(RequestHandler<I, O> router) {
        this(new HttpInterceptorSupport(), router);
    }

    public HttpRequestHandlerBuilder(HttpInterceptorSupport<I, O> interceptorSupport, RequestHandler<I, O> router) {
        this.interceptorSupport = interceptorSupport;
        this.router = router;
    }

    public HttpInterceptorSupport.HttpAttacher<I, O> forKey(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
        return (HttpInterceptorSupport.HttpAttacher)this.interceptorSupport.forKey(key);
    }

    public HttpInterceptorSupport.HttpAttacher<I, O> forUri(String uri) {
        return this.interceptorSupport.forUri(uri);
    }

    public HttpInterceptorSupport.HttpAttacher<I, O> forUriRegex(String uriRegEx) {
        return this.interceptorSupport.forUriRegex(uriRegEx);
    }

    public HttpInterceptorSupport.HttpAttacher<I, O> forHttpMethod(HttpMethod method) {
        return this.interceptorSupport.forHttpMethod(method);
    }

    public HttpInterceptorSupport<I, O> getInterceptorSupport() {
        return this.interceptorSupport;
    }

    public RequestHandler<I, O> getRouter() {
        return this.router;
    }

    public HttpRequestHandler<I, O> build() {
        this.interceptorSupport.finish();
        return new HttpRequestHandler<I, O>(this.router, this.interceptorSupport);
    }
}

