/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import netflix.karyon.transport.http.QueryStringDecoder;
import netflix.karyon.transport.interceptor.KeyEvaluationContext;

public class HttpKeyEvaluationContext
extends KeyEvaluationContext {
    public static final AttributeKey<QueryStringDecoder> queryDecoderKey = AttributeKey.valueOf((String)"_queryStringDecoder");
    private QueryStringDecoder queryStringDecoder;

    public HttpKeyEvaluationContext(Channel channel) {
        super(channel);
        channel.attr(queryDecoderKey).remove();
    }

    String getRequestUriPath(HttpServerRequest<?> httpRequest) {
        String uri = httpRequest.getUri();
        if (null == uri) {
            return null;
        }
        if (null == this.queryStringDecoder) {
            this.queryStringDecoder = null == this.channel ? new QueryStringDecoder(uri) : this.getOrCreateQueryStringDecoder(httpRequest);
        }
        return this.queryStringDecoder.nettyDecoder().path();
    }

    private QueryStringDecoder getOrCreateQueryStringDecoder(HttpServerRequest<?> request) {
        if (null == request) {
            throw new NullPointerException("Request can not be null.");
        }
        String uri = request.getUri();
        if (null == uri) {
            return null;
        }
        Attribute queryDecoderAttr = this.channel.attr(queryDecoderKey);
        QueryStringDecoder _queryStringDecoder = (QueryStringDecoder)queryDecoderAttr.get();
        if (null == _queryStringDecoder) {
            _queryStringDecoder = new QueryStringDecoder(uri);
            queryDecoderAttr.setIfAbsent((Object)_queryStringDecoder);
        }
        return _queryStringDecoder;
    }

    public static QueryStringDecoder getOrCreateQueryStringDecoder(HttpServerRequest<?> request, ChannelHandlerContext channelHandlerContext) {
        if (null == request) {
            throw new NullPointerException("Request can not be null.");
        }
        String uri = request.getUri();
        if (null == uri) {
            return null;
        }
        Attribute queryDecoderAttr = channelHandlerContext.attr(queryDecoderKey);
        QueryStringDecoder _queryStringDecoder = (QueryStringDecoder)queryDecoderAttr.get();
        if (null == _queryStringDecoder) {
            _queryStringDecoder = new QueryStringDecoder(uri);
            queryDecoderAttr.setIfAbsent((Object)_queryStringDecoder);
        }
        return _queryStringDecoder;
    }
}

