/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import netflix.karyon.transport.http.MethodConstraintKey;
import netflix.karyon.transport.http.RegexUriConstraintKey;
import netflix.karyon.transport.http.ServletStyleUriConstraintKey;
import netflix.karyon.transport.interceptor.AbstractAttacher;
import netflix.karyon.transport.interceptor.AbstractInterceptorSupport;
import netflix.karyon.transport.interceptor.InterceptorKey;

public class HttpInterceptorSupport<I, O>
extends AbstractInterceptorSupport<HttpServerRequest<I>, HttpServerResponse<O>, HttpKeyEvaluationContext, HttpAttacher<I, O>, HttpInterceptorSupport<I, O>> {
    @Override
    protected HttpAttacher<I, O> newAttacher(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
        return new HttpAttacher(this, key);
    }

    public HttpAttacher<I, O> forUri(String uri) {
        if (null == uri || uri.isEmpty()) {
            throw new IllegalArgumentException("Uri can not be null or empty.");
        }
        return (HttpAttacher)this.getAttacherForKey(new ServletStyleUriConstraintKey(uri, ""));
    }

    public HttpAttacher<I, O> forUriRegex(String uriRegEx) {
        if (null == uriRegEx || uriRegEx.isEmpty()) {
            throw new IllegalArgumentException("Uri regular expression can not be null or empty.");
        }
        return (HttpAttacher)this.getAttacherForKey(new RegexUriConstraintKey(uriRegEx));
    }

    public HttpAttacher<I, O> forHttpMethod(HttpMethod method) {
        if (null == method) {
            throw new IllegalArgumentException("Uri can not be null or empty.");
        }
        return (HttpAttacher)this.getAttacherForKey(new MethodConstraintKey(method));
    }

    public static class HttpAttacher<I, O>
    extends AbstractAttacher<HttpServerRequest<I>, HttpServerResponse<O>, HttpKeyEvaluationContext, HttpInterceptorSupport<I, O>> {
        public HttpAttacher(HttpInterceptorSupport<I, O> support, InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
            super(support, key);
        }
    }
}

