/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport;

import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RxContexts;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import netflix.karyon.transport.http.HttpRequestHandler;

public final class KaryonTransport {
    public static final String DEFAULT_REQUEST_ID_CTX_KEY = "X-Karyon-REQUEST_ID";

    private KaryonTransport() {
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> router) {
        return RxContexts.newHttpServerBuilder((int)port, new HttpRequestHandler<I, O>(router), (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR);
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, HttpRequestHandler<I, O> requestHandler) {
        return RxContexts.newHttpServerBuilder((int)port, requestHandler, (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR);
    }

    public static <I, O> HttpServer<I, O> newHttpServer(int port, RequestHandler<I, O> router) {
        return KaryonTransport.newHttpServerBuilder(port, router).build();
    }

    public static <I, O> HttpServer<I, O> newHttpServer(int port, HttpRequestHandler<I, O> requestHandler) {
        return KaryonTransport.newHttpServerBuilder(port, requestHandler).build();
    }

    public static void useRequestIdContextKey(String name) {
        RxContexts.useRequestIdContextKey((String)name);
    }

    static {
        RxContexts.useRequestIdContextKey((String)DEFAULT_REQUEST_ID_CTX_KEY);
    }
}

