/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.interceptor;

import io.reactivex.netty.channel.Handler;
import java.util.ArrayList;
import java.util.List;
import netflix.karyon.transport.RequestRouter;
import netflix.karyon.transport.interceptor.AbstractInterceptorSupport;
import netflix.karyon.transport.interceptor.InboundInterceptor;
import netflix.karyon.transport.interceptor.InterceptorHolder;
import netflix.karyon.transport.interceptor.KeyEvaluationContext;
import netflix.karyon.transport.interceptor.OutboundInterceptor;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.subscriptions.SerialSubscription;

public class InterceptorExecutor<I, O, C extends KeyEvaluationContext> {
    private final List<InterceptorHolder<I, C, InboundInterceptor<I, O>>> allIn;
    private final List<InterceptorHolder<I, C, OutboundInterceptor<O>>> allOut;
    private final Handler<I, O> router;

    public InterceptorExecutor(AbstractInterceptorSupport<I, O, C, ?, ?> support, Handler<I, O> router) {
        this.router = router;
        this.allIn = support.getInboundInterceptors();
        this.allOut = support.getOutboundInterceptors();
    }

    @Deprecated
    public InterceptorExecutor(AbstractInterceptorSupport<I, O, C, ?, ?> support, final RequestRouter<I, O> router) {
        this.router = new Handler<I, O>(){

            public Observable<Void> handle(I input, O output) {
                return router.route(input, output);
            }
        };
        this.allIn = support.getInboundInterceptors();
        this.allOut = support.getOutboundInterceptors();
    }

    public Observable<Void> execute(final I request, final O response, C keyEvaluationContext) {
        Observable startingPoint;
        final ExecutionContext context = new ExecutionContext(this, request, keyEvaluationContext);
        InboundInterceptor<I, O> nextIn = context.nextIn(request);
        if (null != nextIn) {
            startingPoint = nextIn.in(request, response);
        } else if (context.invokeRouter()) {
            startingPoint = this.router.handle(request, response);
        } else {
            return Observable.error((Throwable)new IllegalStateException("No router defined."));
        }
        return startingPoint.lift((Observable.Operator)new Observable.Operator<Void, Void>(){

            public Subscriber<? super Void> call(Subscriber<? super Void> child) {
                SerialSubscription subscription = new SerialSubscription();
                ChainSubscriber chainSubscriber = new ChainSubscriber(subscription, context, request, response, child);
                subscription.set((Subscription)chainSubscriber);
                child.add((Subscription)subscription);
                return chainSubscriber;
            }
        });
    }

    private class ChainSubscriber
    extends Subscriber<Void> {
        private final SerialSubscription subscription;
        private final ExecutionContext context;
        private final I request;
        private final O response;
        private final Subscriber<? super Void> child;

        public ChainSubscriber(SerialSubscription subscription, ExecutionContext context, I request, O response, Subscriber<? super Void> child) {
            this.subscription = subscription;
            this.context = context;
            this.request = request;
            this.response = response;
            this.child = child;
        }

        public void onCompleted() {
            InboundInterceptor nextIn = this.context.nextIn(this.request);
            if (null != nextIn) {
                Observable<Void> interceptorResult = nextIn.in(this.request, this.response);
                this.handleResult(interceptorResult);
            } else if (this.context.invokeRouter()) {
                this.handleResult((Observable<Void>)InterceptorExecutor.this.router.handle(this.request, this.response));
            } else {
                OutboundInterceptor nextOut = this.context.nextOut();
                if (null != nextOut) {
                    this.handleResult(nextOut.out(this.response));
                } else {
                    this.child.onCompleted();
                }
            }
        }

        private void handleResult(Observable<Void> aResult) {
            ChainSubscriber nextSubscriber = new ChainSubscriber(this.subscription, this.context, this.request, this.response, this.child);
            this.subscription.set((Subscription)nextSubscriber);
            aResult.unsafeSubscribe((Subscriber)nextSubscriber);
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }

        public void onNext(Void aVoid) {
            this.child.onNext((Object)aVoid);
        }
    }

    private static class ExecutionContext {
        private final C keyEvaluationContext;
        private NextExecutionState nextExecutionState = NextExecutionState.NotStarted;
        private List<OutboundInterceptor<O>> applicableOutInterceptors;
        private int currentHolderIndex;
        private int currentInterceptorIndex;
        final /* synthetic */ InterceptorExecutor this$0;

        public ExecutionContext(I request, C keyEvaluationContext) {
            this.this$0 = var1_1;
            this.keyEvaluationContext = keyEvaluationContext;
            this.applicableOutInterceptors = new ArrayList();
            for (InterceptorHolder holder : ((InterceptorExecutor)var1_1).allOut) {
                switch (((KeyEvaluationContext)keyEvaluationContext).getEvaluationResult(holder.getKey())) {
                    case Apply: {
                        this.applicableOutInterceptors.addAll(holder.getInterceptors());
                        break;
                    }
                    case Skip: {
                        break;
                    }
                    case NotExecuted: {
                        boolean apply = holder.getKey().apply(request, keyEvaluationContext);
                        ((KeyEvaluationContext)keyEvaluationContext).updateKeyEvaluationResult(holder.getKey(), apply);
                        if (!apply) break;
                        this.applicableOutInterceptors.addAll(holder.getInterceptors());
                    }
                }
            }
        }

        public InboundInterceptor<I, O> nextIn(I request) {
            switch (this.nextExecutionState) {
                case NotStarted: {
                    this.nextExecutionState = NextExecutionState.NextInInterceptor;
                    return this.nextIn(request);
                }
                case NextInHolder: {
                    ++this.currentHolderIndex;
                    this.currentInterceptorIndex = 0;
                    this.nextExecutionState = NextExecutionState.NextInInterceptor;
                    return this.nextIn(request);
                }
                case NextInInterceptor: {
                    if (this.currentHolderIndex >= this.this$0.allIn.size()) {
                        this.nextExecutionState = NextExecutionState.Router;
                        return null;
                    }
                    InterceptorHolder holder = (InterceptorHolder)this.this$0.allIn.get(this.currentHolderIndex);
                    switch (((KeyEvaluationContext)this.keyEvaluationContext).getEvaluationResult(holder.getKey())) {
                        case Apply: {
                            return this.returnNextInterceptor(request, holder);
                        }
                        case Skip: {
                            this.nextExecutionState = NextExecutionState.NextInHolder;
                            return this.nextIn(request);
                        }
                        case NotExecuted: {
                            boolean apply = holder.getKey().apply(request, this.keyEvaluationContext);
                            ((KeyEvaluationContext)this.keyEvaluationContext).updateKeyEvaluationResult(holder.getKey(), apply);
                            return this.nextIn(request);
                        }
                    }
                }
            }
            return null;
        }

        public OutboundInterceptor<O> nextOut() {
            switch (this.nextExecutionState) {
                case NextOutInterceptor: {
                    if (this.currentInterceptorIndex >= this.applicableOutInterceptors.size()) {
                        this.nextExecutionState = NextExecutionState.End;
                        return null;
                    }
                    return this.applicableOutInterceptors.get(this.currentInterceptorIndex++);
                }
            }
            return null;
        }

        private InboundInterceptor<I, O> returnNextInterceptor(I request, InterceptorHolder<I, C, InboundInterceptor<I, O>> holder) {
            List interceptors = holder.getInterceptors();
            if (this.currentInterceptorIndex >= interceptors.size()) {
                this.nextExecutionState = NextExecutionState.NextInHolder;
                return this.nextIn(request);
            }
            return interceptors.get(this.currentInterceptorIndex++);
        }

        public boolean invokeRouter() {
            if (NextExecutionState.Router == this.nextExecutionState) {
                this.currentHolderIndex = 0;
                this.nextExecutionState = NextExecutionState.NextOutInterceptor;
                return true;
            }
            return false;
        }
    }

    private static enum NextExecutionState {
        NotStarted,
        NextInHolder,
        NextInInterceptor,
        Router,
        NextOutInterceptor,
        End;

    }
}

