/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import netflix.karyon.transport.http.HttpInterceptorKey;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexUriConstraintKey<I>
implements HttpInterceptorKey<I> {
    private static final Logger logger = LoggerFactory.getLogger(RegexUriConstraintKey.class);
    private final Pattern regEx;

    public RegexUriConstraintKey(String constraint) {
        if (null == constraint) {
            throw new NullPointerException("Constraint can not be null.");
        }
        this.regEx = Pattern.compile(constraint);
    }

    public String toString() {
        return "RegexUriConstraintKey{regEx=" + this.regEx + '}';
    }

    @Override
    public boolean apply(HttpServerRequest<I> request, HttpKeyEvaluationContext context) {
        String requestUriPath = context.getRequestUriPath(request);
        boolean matches = false;
        if (null != requestUriPath) {
            Matcher matcher = this.regEx.matcher(requestUriPath);
            matches = matcher.matches();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Result for regex based uri constraint for uri path {} and pattern {} : {}", new Object[]{requestUriPath, this.regEx, matches});
        }
        return matches;
    }
}

