/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import netflix.karyon.transport.interceptor.AbstractAttacher;
import netflix.karyon.transport.interceptor.InboundInterceptor;
import netflix.karyon.transport.interceptor.InterceptorHolder;
import netflix.karyon.transport.interceptor.InterceptorKey;
import netflix.karyon.transport.interceptor.KeyEvaluationContext;
import netflix.karyon.transport.interceptor.OutboundInterceptor;

public abstract class AbstractInterceptorSupport<I, O, C extends KeyEvaluationContext, A extends AbstractAttacher<I, O, C, S>, S extends AbstractInterceptorSupport<I, O, C, A, S>> {
    protected final Map<InterceptorKey<I, C>, A> attachers = new HashMap<InterceptorKey<I, C>, A>();
    protected List<InterceptorHolder<I, C, InboundInterceptor<I, O>>> inboundInterceptors = new LinkedList<InterceptorHolder<I, C, InboundInterceptor<I, O>>>();
    protected List<InterceptorHolder<I, C, OutboundInterceptor<O>>> outboundInterceptors = new LinkedList<InterceptorHolder<I, C, OutboundInterceptor<O>>>();
    protected boolean finished;

    protected List<InterceptorHolder<I, C, InboundInterceptor<I, O>>> getInboundInterceptors() {
        return this.inboundInterceptors;
    }

    protected List<InterceptorHolder<I, C, OutboundInterceptor<O>>> getOutboundInterceptors() {
        return this.outboundInterceptors;
    }

    public A forKey(InterceptorKey<I, C> key) {
        if (this.finished) {
            throw new IllegalArgumentException("Interceptor support can not be modified after finishing.");
        }
        return this.getAttacherForKey(key);
    }

    protected A getAttacherForKey(InterceptorKey<I, C> key) {
        AbstractAttacher attacher = (AbstractAttacher)this.attachers.get(key);
        if (null == attacher) {
            attacher = this.newAttacher(key);
            this.attachers.put(key, attacher);
        }
        return (A)attacher;
    }

    protected abstract A newAttacher(InterceptorKey<I, C> var1);

    public boolean hasAtleastOneInterceptor() {
        return !this.inboundInterceptors.isEmpty() || !this.outboundInterceptors.isEmpty();
    }

    public S finish() {
        if (!this.finished) {
            this._finish();
            this.finished = true;
        }
        return this.returnSupport();
    }

    protected void _finish() {
        this.attachers.clear();
        this.inboundInterceptors = Collections.unmodifiableList(this.inboundInterceptors);
        this.outboundInterceptors = Collections.unmodifiableList(this.outboundInterceptors);
    }

    protected S returnSupport() {
        return (S)this;
    }
}

