/*
 * Decompiled with CFR 0.152.
 */
package netflix.admin;

import com.netflix.config.ConfigurationManager;
import javax.inject.Singleton;
import netflix.admin.AdminContainerConfig;

@Singleton
public class AdminConfigImpl
implements AdminContainerConfig {
    public static final String NETFLIX_ADMIN_TEMPLATE_CONTEXT = "netflix.admin.template.context";
    public static final String TEMPLATE_CONTEXT_DEFAULT = "/admin";
    public static final String NETFLIX_ADMIN_RESOURCE_CONTEXT = "netflix.admin.resource.context";
    public static final String RESOURCE_CONTEXT_DEFAULT = "/webadmin";
    private static final String JERSEY_CORE_RESOURCES = "netflix.platform.admin.resources.core.packages";
    public static final String JERSEY_CORE_RESOURCES_DEFAULT = "netflix.adminresources;com.netflix.explorers.resources;com.netflix.explorers.providers";
    private static final String JERSEY_VIEWABLE_RESOURCES = "netflix.platform.admin.resources.viewable.packages";
    public static final String JERSEY_VIEWABLE_RESOURCES_DEFAULT = "netflix.admin;netflix.adminresources.pages;com.netflix.explorers.resources";
    public static final String CONTAINER_LISTEN_PORT = "netflix.platform.admin.resources.port";
    public static final int LISTEN_PORT_DEFAULT = 8077;
    public static final String SERVER_ENABLE_PROP_NAME = "netflix.platform.admin.resources.enable";
    public static final boolean SERVER_ENABLE_DEFAULT = true;
    public static final String NETFLIX_ADMIN_RESOURCES_ISOLATE = "netflix.admin.resources.isolate";
    public static final boolean ISOLATE_RESOURCES_DEFAULT = false;
    private final String templateResContext;
    private final String resourceContext;
    private final String coreJerseyResources;
    private final String viewableResources;
    private final int listenPort;
    private final boolean isEnabled = ConfigurationManager.getConfigInstance().getBoolean("netflix.platform.admin.resources.enable", true);
    private final boolean isResourcesIsolated;

    public AdminConfigImpl() {
        this.templateResContext = ConfigurationManager.getConfigInstance().getString(NETFLIX_ADMIN_TEMPLATE_CONTEXT, TEMPLATE_CONTEXT_DEFAULT);
        this.resourceContext = ConfigurationManager.getConfigInstance().getString(NETFLIX_ADMIN_RESOURCE_CONTEXT, RESOURCE_CONTEXT_DEFAULT);
        this.coreJerseyResources = ConfigurationManager.getConfigInstance().getString(JERSEY_CORE_RESOURCES, JERSEY_CORE_RESOURCES_DEFAULT);
        this.viewableResources = ConfigurationManager.getConfigInstance().getString(JERSEY_VIEWABLE_RESOURCES, JERSEY_VIEWABLE_RESOURCES_DEFAULT);
        this.listenPort = ConfigurationManager.getConfigInstance().getInt(CONTAINER_LISTEN_PORT, 8077);
        this.isResourcesIsolated = ConfigurationManager.getConfigInstance().getBoolean(NETFLIX_ADMIN_RESOURCES_ISOLATE, false);
    }

    @Override
    public boolean shouldIsolateResources() {
        return this.isResourcesIsolated;
    }

    @Override
    public boolean shouldEnable() {
        return this.isEnabled;
    }

    @Override
    public String templateResourceContext() {
        return this.templateResContext;
    }

    @Override
    public String ajaxDataResourceContext() {
        return this.resourceContext;
    }

    @Override
    public String jerseyResourcePkgList() {
        return this.coreJerseyResources;
    }

    @Override
    public String jerseyViewableResourcePkgList() {
        return this.viewableResources;
    }

    @Override
    public boolean shouldScanClassPathForPluginDiscovery() {
        return true;
    }

    @Override
    public int listenPort() {
        return this.listenPort;
    }
}

