/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import netflix.admin.AdminConfigImpl;
import netflix.admin.AdminContainerConfig;
import netflix.adminresources.AdminPageInfo;
import netflix.adminresources.AdminPageRegistry;
import netflix.adminresources.AdminResourcesFilter;
import netflix.adminresources.LoggingFilter;
import netflix.adminresources.RedirectFilter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdminResourcesContainer {
    private static final Logger logger = LoggerFactory.getLogger(AdminResourcesContainer.class);
    @Deprecated
    public static final String CONTAINER_LISTEN_PORT = "netflix.platform.admin.resources.port";
    private Server server;
    @Inject(optional=true)
    private Injector appInjector;
    @Inject(optional=true)
    private AdminContainerConfig adminContainerConfig;
    @Inject(optional=true)
    private AdminPageRegistry adminPageRegistry;
    private AtomicBoolean alreadyInited = new AtomicBoolean(false);
    private int serverPort;

    @PostConstruct
    public void init() throws Exception {
        try {
            if (this.alreadyInited.compareAndSet(false, true)) {
                Injector adminResourceInjector;
                this.initAdminContainerConfigIfNeeded();
                this.initAdminRegistryIfNeeded();
                if (this.adminContainerConfig.shouldScanClassPathForPluginDiscovery()) {
                    this.adminPageRegistry.registerAdminPagesWithClasspathScan();
                }
                if (this.appInjector != null) {
                    adminResourceInjector = this.appInjector.createChildInjector(this.buildAdminPluginsGuiceModules());
                } else {
                    adminResourceInjector = LifecycleInjector.builder().inStage(Stage.DEVELOPMENT).withMode(LifecycleInjectorMode.SIMULATED_CHILD_INJECTORS).usingBasePackages(new String[]{"com.netflix.explorers"}).withModules(this.buildAdminPluginsGuiceModules()).build().createInjector();
                    ((LifecycleManager)adminResourceInjector.getInstance(LifecycleManager.class)).start();
                }
                this.server = new Server(this.adminContainerConfig.listenPort());
                ServletContextHandler rootHandler = new ServletContextHandler();
                rootHandler.setContextPath("/");
                rootHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", EnumSet.allOf(DispatcherType.class));
                rootHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                AdminResourcesFilter arfTemplatesResources = (AdminResourcesFilter)((Object)adminResourceInjector.getInstance(AdminResourcesFilter.class));
                arfTemplatesResources.setPackages(this.adminContainerConfig.jerseyViewableResourcePkgList());
                ServletContextHandler adminTemplatesResHandler = new ServletContextHandler();
                adminTemplatesResHandler.setContextPath(this.adminContainerConfig.templateResourceContext());
                adminTemplatesResHandler.setSessionHandler(new SessionHandler());
                adminTemplatesResHandler.addFilter(LoggingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
                adminTemplatesResHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", EnumSet.allOf(DispatcherType.class));
                adminTemplatesResHandler.addFilter(new FilterHolder((Filter)arfTemplatesResources), "/*", EnumSet.allOf(DispatcherType.class));
                adminTemplatesResHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                String jerseyPkgListForAjaxResources = this.appendCoreJerseyPackages(this.adminPageRegistry.buildJerseyResourcePkgListForAdminPages());
                AdminResourcesFilter arfDataResources = (AdminResourcesFilter)((Object)adminResourceInjector.getInstance(AdminResourcesFilter.class));
                arfDataResources.setPackages(jerseyPkgListForAjaxResources);
                ServletContextHandler adminDataResHandler = new ServletContextHandler();
                adminDataResHandler.setContextPath(this.adminContainerConfig.ajaxDataResourceContext());
                adminDataResHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", EnumSet.allOf(DispatcherType.class));
                adminDataResHandler.addFilter(new FilterHolder((Filter)arfDataResources), "/*", EnumSet.allOf(DispatcherType.class));
                adminDataResHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                HandlerCollection handlers = new HandlerCollection();
                handlers.setHandlers(new Handler[]{adminTemplatesResHandler, adminDataResHandler, rootHandler});
                this.server.setHandler((Handler)handlers);
                this.server.start();
                ServerConnector connector = (ServerConnector)this.server.getConnectors()[0];
                this.serverPort = connector.getLocalPort();
            }
        }
        catch (Exception e) {
            logger.error("Exception in building AdminResourcesContainer ", (Throwable)e);
        }
    }

    private void initAdminContainerConfigIfNeeded() {
        if (this.adminContainerConfig == null) {
            this.adminContainerConfig = new AdminConfigImpl();
        }
    }

    private void initAdminRegistryIfNeeded() {
        if (this.adminPageRegistry == null) {
            this.adminPageRegistry = new AdminPageRegistry();
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public AdminPageRegistry getAdminPageRegistry() {
        return this.adminPageRegistry;
    }

    private Module getAdditionalBindings() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(AdminResourcesFilter.class);
            }
        };
    }

    private String appendCoreJerseyPackages(String jerseyResourcePkgListForAdminPages) {
        String pkgPath = this.adminContainerConfig.jerseyResourcePkgList();
        if (jerseyResourcePkgListForAdminPages != null && !jerseyResourcePkgListForAdminPages.isEmpty()) {
            pkgPath = pkgPath + ";" + jerseyResourcePkgListForAdminPages;
        }
        return pkgPath;
    }

    private List<Module> buildAdminPluginsGuiceModules() {
        ArrayList<Module> guiceModules = new ArrayList<Module>();
        if (this.adminPageRegistry != null) {
            Collection<AdminPageInfo> allPages = this.adminPageRegistry.getAllPages();
            for (AdminPageInfo adminPlugin : allPages) {
                List<Module> guiceModuleList = adminPlugin.getGuiceModules();
                if (guiceModuleList == null || guiceModuleList.isEmpty()) continue;
                guiceModules.addAll(adminPlugin.getGuiceModules());
            }
        }
        guiceModules.add(this.getAdditionalBindings());
        return guiceModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void shutdown() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable t) {
            logger.warn("Error while shutting down Admin resources server", t);
        }
        finally {
            this.alreadyInited.set(false);
        }
    }
}

