/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netflix.admin.RedirectRules;

@Singleton
public class RedirectFilter
implements Filter {
    private RedirectRules redirectRules;

    @Inject
    public RedirectFilter(RedirectRules redirectRules) {
        this.redirectRules = redirectRules;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        Map<String, String> mappings = this.redirectRules.getMappings();
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            if (!requestURI.equals(mapping.getKey())) continue;
            ((HttpServletResponse)response).sendRedirect(mapping.getValue());
            return;
        }
        chain.doFilter((ServletRequest)httpRequest, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

