/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.inject.Inject;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/healthcheck")
@Singleton
public class HealthcheckResource {
    @Inject(optional=true)
    private HealthCheckInvocationStrategy invocationStrategy;

    @GET
    public Response doHealthCheck() {
        if (null != this.invocationStrategy) {
            try {
                int status = this.invocationStrategy.invokeCheck();
                return Response.status((int)status).build();
            }
            catch (TimeoutException e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

