/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.netflix.adminresources.HealthCheckServlet;
import com.netflix.adminresources.LoggingFilter;
import com.netflix.adminresources.RedirectFilter;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.governator.annotations.Configuration;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.netflix.karyon.spi.Component;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(disableProperty="netflix.platform.admin.resources.disable")
public class AdminResourcesContainer {
    private static final Logger logger = LoggerFactory.getLogger(AdminResourcesContainer.class);
    public static final String DEFAULT_PAGE_PROP_NAME = "com.netflix.karyon.admin.default.page";
    public static final DynamicStringProperty DEFAULT_PAGE = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.karyon.admin.default.page", "/healthcheck");
    public static final String CONTAINER_LISTEN_PORT = "netflix.platform.admin.resources.port";
    public static final int LISTEN_PORT_DEFAULT = 8077;
    public static final String JERSEY_CORE_PACKAGES = "netflix.platform.admin.resources.core.packages";
    public static final String JERSEY_CORE_PACKAGES_DEAULT = "com.netflix.adminresources";
    public static final String JERSEY_APP_PACKAGES = "netflix.platform.admin.resources.packages";
    @Configuration(value="netflix.platform.admin.resources.port", documentation="Property defining the listen port for admin resources.", ignoreTypeMismatch=true)
    private int listenPort = 8077;
    @Configuration(value="netflix.platform.admin.resources.core.packages", documentation="Property defining the list of core packages which contains jersey resources for karyon admin. com.netflix.adminresources is always added to this.")
    private String coreJerseyPackages = "com.netflix.adminresources";
    @Configuration(value="netflix.platform.admin.resources.packages", documentation="Property defining the list of additional packages which contains jersey resources for karyon admin. This will be on top of the core packages.")
    private String appJerseyPackages = "";
    private Server server;
    private final HealthCheckInvocationStrategy healthCheckInvocationStrategy;

    @Inject
    public AdminResourcesContainer(HealthCheckInvocationStrategy healthCheckInvocationStrategy) {
        this.healthCheckInvocationStrategy = healthCheckInvocationStrategy;
    }

    @PostConstruct
    public void init() {
        if (!this.coreJerseyPackages.equals(JERSEY_CORE_PACKAGES_DEAULT)) {
            this.coreJerseyPackages = Joiner.on((String)",").join((Object)this.coreJerseyPackages, (Object)JERSEY_CORE_PACKAGES_DEAULT, new Object[0]);
        }
        String packages = Joiner.on((String)",").join(this.getAdminResourcePackages());
        this.server = new Server(this.listenPort);
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder(ServletContainer.class);
        servletHolder.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        servletHolder.setInitParameter("com.sun.jersey.config.property.packages", packages);
        handler.addServlet(servletHolder, "/*");
        ServletHolder hcServlet = new ServletHolder((Servlet)new HealthCheckServlet(this.healthCheckInvocationStrategy));
        handler.addServlet(hcServlet, "/healthcheck");
        FilterHolder loggingFilter = new FilterHolder((Filter)new LoggingFilter());
        FilterHolder redirectFilter = new FilterHolder((Filter)new RedirectFilter());
        handler.addFilter(loggingFilter, "/*", EnumSet.allOf(DispatcherType.class));
        handler.addFilter(redirectFilter, "/*", EnumSet.allOf(DispatcherType.class));
        this.server.setHandler((Handler)handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.error(String.format("Failed to start admin resource container, karyon admin console on port %s will not be available.", this.listenPort), (Throwable)e);
        }
    }

    private Iterable getAdminResourcePackages() {
        return Arrays.asList(this.coreJerseyPackages, this.appJerseyPackages);
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Throwable t) {
            logger.warn("Error while shutting down Admin resources server", t);
        }
    }
}

