/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sun.jersey.api.NotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/adminres")
public class EmbeddedContentResource {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedContentResource.class);
    private static final ImmutableMap<String, String> EXT_TO_MEDIATYPE = new ImmutableMap.Builder().put((Object)"js", (Object)"text/javascript").put((Object)"png", (Object)"image/png").put((Object)"gif", (Object)"image/gif").put((Object)"css", (Object)"text/css").put((Object)"jpg", (Object)"image/jpeg").put((Object)"jpeg", (Object)"image/jpeg").put((Object)"html", (Object)"text/html").build();
    private ConcurrentMap<String, byte[]> resourceCache = Maps.newConcurrentMap();
    @Context
    private UriInfo uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{subResources:.*}")
    public Response get() {
        String path = this.uriInfo.getPath().substring("adminres".length());
        String ext = StringUtils.substringAfterLast((String)path, (String)".");
        String mediaType = (String)EXT_TO_MEDIATYPE.get((Object)ext);
        byte[] contentAsBytes = null;
        if (mediaType != null) {
            if (this.resourceCache.containsKey(path)) {
                contentAsBytes = (byte[])this.resourceCache.get(path);
            } else {
                InputStream is = this.getClass().getResourceAsStream(path);
                if (is != null) {
                    try {
                        int bytesRead;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                        byte[] chunk = new byte[4096];
                        while ((bytesRead = is.read(chunk)) > 0) {
                            baos.write(chunk, 0, bytesRead);
                        }
                        contentAsBytes = baos.toByteArray();
                        byte[] existing = this.resourceCache.putIfAbsent(path, contentAsBytes);
                        if (null != existing) {
                            contentAsBytes = existing;
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error loading resource with path: " + this.uriInfo.getPath(), (Throwable)e);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.info("Could not close the resource stream for loading admin resource, ignoring.", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (contentAsBytes == null) {
            logger.info("Could not find resource: " + this.uriInfo.getPath());
            throw new NotFoundException();
        }
        return Response.ok(contentAsBytes, (String)mediaType).build();
    }
}

