/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LoggingFilter.class);
    private static Pattern PATTERN_FOR_CSS_JS_ETC = Pattern.compile(".*js$|.*png$|.*gif$|.*css$|.*jpg$|.*jpeg$|.*ico$");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!PATTERN_FOR_CSS_JS_ETC.matcher(httpRequest.getRequestURI()).matches()) {
            StringBuilder sb = new StringBuilder("AdminResources request details: ");
            sb.append(httpRequest.getRemoteHost()).append(" ").append(httpRequest.getRemoteAddr()).append(" ").append(httpRequest.getMethod()).append(" ").append(httpRequest.getRequestURI());
            logger.info(sb.toString());
        }
        chain.doFilter((ServletRequest)httpRequest, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

