/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources;

import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckServlet.class);
    public static final String PATH = "/healthcheck";
    private HealthCheckInvocationStrategy healthCheckInvocationStrategy;

    public HealthCheckServlet(HealthCheckInvocationStrategy healthCheckInvocationStrategy) {
        this.healthCheckInvocationStrategy = healthCheckInvocationStrategy;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            int status = this.healthCheckInvocationStrategy.invokeCheck();
            resp.setStatus(status);
        }
        catch (TimeoutException e) {
            logger.error("Karyon health check failed via adminresource health endpoint. Returning 500", (Throwable)e);
            resp.sendError(500);
        }
    }
}

