/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.adminresources.resources.MaskedResourceHelper;
import com.netflix.adminresources.resources.PairResponse;
import com.netflix.config.ConfigurationManager;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/webadmin/props")
@Produces(value={"application/json"})
@Beta
public class PropertiesResource {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesResource.class);

    @GET
    public Response getAllProperties() {
        TreeMap<String, String> allPropsAsString = new TreeMap<String, String>();
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Iterator keys = config.getKeys();
        Set<String> maskedResources = MaskedResourceHelper.getMaskedResourceSet();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = maskedResources.contains(key) ? "**** MASKED ****" : config.getProperty(key);
            if (null == value) continue;
            allPropsAsString.put(key, value.toString());
        }
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new PairResponse(allPropsAsString));
        return Response.ok((Object)propsJson).build();
    }
}

