/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.sun.jersey.api.view.Viewable;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
@Produces(value={"text/html"})
public class AdminPageResource {
    private static final Logger LOG = LoggerFactory.getLogger(AdminPageResource.class);

    @GET
    public Viewable showIndex() {
        LOG.info("showIndex");
        HashMap model = new HashMap();
        return new Viewable("/webadmin/home.ftl", model);
    }

    @GET
    @Path(value="/{view}")
    public Viewable showViewIndex(@PathParam(value="view") String view, @QueryParam(value="id") @DefaultValue(value="") String id) {
        LOG.info(view);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        model.put("instance_hostname", this.getInstanceHostName(id));
        return new Viewable("/webadmin/" + view + "/index.ftl", model);
    }

    private String getInstanceHostName(String id) {
        if (id != null && !id.isEmpty()) {
            List instances = DiscoveryManager.getInstance().getDiscoveryClient().getInstancesById(id);
            if (instances == null || instances.isEmpty()) {
                throw new WebApplicationException((Throwable)new Exception("Hostname for instance " + id + " not found"), 404);
            }
            return ((InstanceInfo)instances.get(0)).getHostName();
        }
        return "";
    }

    @POST
    @Path(value="/{view}")
    public Viewable createObject(@PathParam(value="view") String view, @QueryParam(value="id") @DefaultValue(value="") String id) {
        LOG.info(view);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        model.put("instance_hostname", this.getInstanceHostName(id));
        return new Viewable("/webadmin/" + view + "/create.ftl", model);
    }

    @GET
    @Path(value="/jmx/mbean")
    public Viewable showJMXMbean(@QueryParam(value="id") String id, @QueryParam(value="key") String key) {
        LOG.info("");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        model.put("key", key);
        return new Viewable("/webadmin/jmx/view.ftl", model);
    }
}

