/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.adminresources.resources.KaryonAdminResponse;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/webadmin/jars")
@Produces(value={"application/json"})
@Beta
public class JarsInfoResource {
    private static final Logger logger = LoggerFactory.getLogger(JarsInfoResource.class);
    private static final String JAR_PATTERN = "^jar:file:(.+)!/META-INF/MANIFEST.MF$";

    @GET
    public Response getAllJarsInfo() {
        List<JarInfo> jarInfo = this.getJarInfo();
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new KaryonAdminResponse(jarInfo));
        return Response.ok((Object)propsJson).build();
    }

    private List<JarInfo> getJarInfo() {
        ArrayList<JarInfo> toReturn = new ArrayList<JarInfo>();
        Pattern pattern = Pattern.compile(JAR_PATTERN);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL manifestURL = urls.nextElement();
                InputStream is = manifestURL.openStream();
                String key = manifestURL.toString();
                Matcher matcher = pattern.matcher(key);
                if (matcher.matches()) {
                    key = matcher.group(1);
                }
                Attributes mainAttributes = new Manifest(is).getMainAttributes();
                toReturn.add(new JarInfo(key, mainAttributes));
                is.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to load environment jar information.", (Throwable)e);
        }
        return toReturn;
    }

    private static class JarInfo {
        public static final String MANIFEST_VERSION = "Manifest-Version";
        public static final String CREATED_BY = "Created-By";
        public static final String UNAVAILABLE = "Unavailable";
        private String jar;
        private String createdBy = "Unavailable";
        private String manifestVersion = "Unavailable";

        public JarInfo(String key, Attributes mainAttributes) {
            this.jar = key;
            if (null != mainAttributes.getValue(MANIFEST_VERSION)) {
                this.manifestVersion = String.valueOf(mainAttributes.getValue(MANIFEST_VERSION));
            }
            if (null != mainAttributes.getValue(CREATED_BY)) {
                this.createdBy = String.valueOf(mainAttributes.getValue(CREATED_BY));
            }
        }

        public String getJar() {
            return this.jar;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public String getManifestVersion() {
            return this.manifestVersion;
        }
    }
}

