/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.adminresources.resources.KaryonAdminResponse;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/webadmin/jmx")
@Produces(value={"application/json"})
@Beta
public class JMXResource {
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String CURRENT_VALUE = "CurrentValue";

    @GET
    public Response getJmxBeans() {
        String[] domains;
        ArrayList<MbeanData> mbeans = new ArrayList<MbeanData>();
        for (String domain : domains = this.mBeanServer.getDomains()) {
            ObjectName name = null;
            try {
                name = new ObjectName(domain + ":*");
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
            Set<ObjectName> objs = this.mBeanServer.queryNames(name, null);
            for (ObjectName obj : objs) {
                MbeanData data = new MbeanData();
                data.displayName = obj.getCanonicalName();
                try {
                    data.attributes = this.getMBeanAttributes(obj);
                    mbeans.add(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new KaryonAdminResponse(mbeans));
        return Response.ok((Object)propsJson).build();
    }

    private Map<String, String> getMBeanAttributes(ObjectName objName) throws Exception {
        MBeanAttributeInfo[] attrs;
        LinkedHashMap response = Maps.newLinkedHashMap();
        MBeanInfo mBeanInfo = this.mBeanServer.getMBeanInfo(objName);
        if (mBeanInfo != null && (attrs = mBeanInfo.getAttributes()) != null) {
            ArrayList attrNames = Lists.newArrayList();
            for (MBeanAttributeInfo attr : attrs) {
                attrNames.add(attr.getName());
            }
            AttributeList attrList = this.mBeanServer.getAttributes(objName, attrNames.toArray(new String[attrNames.size()]));
            for (Attribute attr : attrList.asList()) {
                String attrName = attr.getName();
                Object value = attr.getValue();
                String attrValue = null;
                if (value != null) {
                    if (value instanceof CompositeDataSupport) {
                        CompositeDataSupport compositeValue = (CompositeDataSupport)value;
                        try {
                            if (compositeValue.containsKey(CURRENT_VALUE)) {
                                Object curValue = compositeValue.get(CURRENT_VALUE);
                                attrValue = curValue == null ? "null" : curValue.toString();
                            }
                        }
                        catch (Exception e) {
                            attrValue = compositeValue.toString();
                        }
                    }
                    if (attrValue == null) {
                        attrValue = value.toString();
                    }
                } else {
                    attrValue = "none";
                }
                response.put(attrName, attrValue);
            }
        }
        return response;
    }

    private static class MbeanData {
        private String displayName;
        private Map<String, String> attributes;

        private MbeanData() {
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

