/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.adminresources.resources.JarsInfoResource;
import com.netflix.adminresources.resources.KaryonAdminResponse;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.karyon.server.utils.KaryonUtils;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/webadmin/eureka")
@Produces(value={"application/json"})
@Beta
public class EurekaResource {
    private static final Logger logger = LoggerFactory.getLogger(JarsInfoResource.class);

    @GET
    public Response getEurekaDetails() {
        ArrayList<EurekaInstanceInfo> instanceInfoList = new ArrayList<EurekaInstanceInfo>();
        if (!KaryonUtils.isCoreComponentEnabled((String)"eureka")) {
            logger.info("Eureka is not enabled, so not fetching eureka details.");
        } else {
            DiscoveryClient discoveryClient = DiscoveryManager.getInstance().getDiscoveryClient();
            if (null != discoveryClient) {
                Applications apps = discoveryClient.getApplications();
                for (Application app : apps.getRegisteredApplications()) {
                    for (InstanceInfo inst : app.getInstances()) {
                        instanceInfoList.add(new EurekaInstanceInfo(inst.getAppName(), inst.getId(), inst.getStatus().name(), inst.getIPAddr(), inst.getHostName()));
                    }
                }
            }
        }
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String response = gson.toJson((Object)new KaryonAdminResponse(instanceInfoList));
        return Response.ok((Object)response).build();
    }

    private static class EurekaInstanceInfo {
        private String application;
        private String id;
        private String status;
        private String ipAddress;
        private String hostName;

        private EurekaInstanceInfo(String application, String id, String status, String ipAddress, String hostName) {
            this.application = application;
            this.id = id;
            this.status = status;
            this.ipAddress = ipAddress;
            this.hostName = hostName;
        }

        public String getApplication() {
            return this.application;
        }

        public String getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostName() {
            return this.hostName;
        }
    }
}

