/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashSet;
import java.util.Set;

public class MaskedResourceHelper {
    @VisibleForTesting
    public static final String MASKED_PROPERTY_NAMES = "netflix.platform.admin.resources.masked.property.names";
    public static final String MASKED_PROPERTY_VALUE = "**** MASKED ****";
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public static Set<String> getMaskedResourceSet() {
        String maskedResourceNames = DynamicPropertyFactory.getInstance().getStringProperty(MASKED_PROPERTY_NAMES, "").get();
        Iterable maskedResourceNamesIter = SPLITTER.split((CharSequence)maskedResourceNames);
        HashSet<String> maskedResourceSet = new HashSet<String>();
        for (String maskedResource : maskedResourceNamesIter) {
            maskedResourceSet.add(maskedResource);
        }
        maskedResourceSet.add(MASKED_PROPERTY_NAMES);
        return maskedResourceSet;
    }
}

