/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.demo;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.examples.demo.CreditCardAuthorizationResult;
import com.netflix.hystrix.examples.demo.GetUserAccountCommand;
import com.netflix.hystrix.examples.demo.Order;
import com.netflix.hystrix.examples.demo.PaymentInformation;
import com.netflix.hystrix.examples.demo.UserAccount;
import java.math.BigDecimal;
import java.net.HttpCookie;

public class CreditCardCommand
extends HystrixCommand<CreditCardAuthorizationResult> {
    private static final AuthorizeNetGateway DEFAULT_GATEWAY = new AuthorizeNetGateway();
    private final AuthorizeNetGateway gateway;
    private final Order order;
    private final PaymentInformation payment;
    private final BigDecimal amount;

    public CreditCardCommand(Order order, PaymentInformation payment, BigDecimal amount) {
        this(DEFAULT_GATEWAY, order, payment, amount);
    }

    private CreditCardCommand(AuthorizeNetGateway gateway, Order order, PaymentInformation payment, BigDecimal amount) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"CreditCard")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(3000)));
        this.gateway = gateway;
        this.order = order;
        this.payment = payment;
        this.amount = amount;
    }

    protected CreditCardAuthorizationResult run() {
        Result<Transaction> result;
        UserAccount user = (UserAccount)new GetUserAccountCommand(new HttpCookie("mockKey", "mockValueFromHttpRequest")).execute();
        if (user.getAccountType() == 1) {
            // empty if block
        }
        if ((result = this.gateway.submit(this.payment.getCreditCardNumber(), String.valueOf(this.payment.getExpirationMonth()), String.valueOf(this.payment.getExpirationYear()), TransactionType.AUTH_CAPTURE, this.amount, this.order)).isApproved()) {
            return CreditCardAuthorizationResult.createSuccessResponse(result.getTarget().getTransactionId(), result.getTarget().getAuthorizationCode());
        }
        if (result.isDeclined()) {
            return CreditCardAuthorizationResult.createFailedResponse(result.getReasonResponseCode() + " : " + result.getResponseText());
        }
        if (result.getReasonResponseCode().getResponseReasonCode() == 11 && result.getTarget().getAuthorizationCode() != null) {
            return CreditCardAuthorizationResult.createDuplicateSuccessResponse(result.getTarget().getTransactionId(), result.getTarget().getAuthorizationCode());
        }
        return CreditCardAuthorizationResult.createFailedResponse(result.getReasonResponseCode() + " : " + result.getResponseText());
    }

    public static enum TransactionType {
        AUTH_CAPTURE;

    }

    public static class Transaction {
    }

    public static class Target {
        public String getTransactionId() {
            return "transactionId";
        }

        public String getAuthorizationCode() {
            return "authorizedCode";
        }
    }

    public static class ResponseCode {
        public int getResponseReasonCode() {
            return 0;
        }
    }

    public static class Result<T> {
        private final boolean approved;

        public Result(boolean approved) {
            this.approved = approved;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public ResponseCode getResponseText() {
            return null;
        }

        public Target getTarget() {
            return new Target();
        }

        public ResponseCode getReasonResponseCode() {
            return new ResponseCode();
        }

        public boolean isDeclined() {
            return !this.approved;
        }
    }

    public static class AuthorizeNetGateway {
        public Result<Transaction> submit(String creditCardNumber, String expirationMonth, String expirationYear, TransactionType authCapture, BigDecimal amount, Order order) {
            try {
                Thread.sleep((int)(Math.random() * 700.0) + 800);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Math.random() > 0.99) {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (Math.random() < 0.8) {
                return new Result<Transaction>(true);
            }
            return new Result<Transaction>(false);
        }
    }
}

