/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixObservableCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

class ObservableCommandNumbersToWords
extends HystrixObservableCommand<NumberWord> {
    private final List<Integer> numbers;
    static Map<Integer, String> dict = new HashMap<Integer, String>(11);

    public ObservableCommandNumbersToWords(List<Integer> numbers) {
        super(HystrixCommandGroupKey.Factory.asKey((String)ObservableCommandNumbersToWords.class.getName()));
        this.numbers = numbers;
    }

    protected Observable<NumberWord> construct() {
        return Observable.from(this.numbers).map((Func1)new Func1<Integer, NumberWord>(){

            public NumberWord call(Integer number) {
                return new NumberWord(number, dict.get(number));
            }
        });
    }

    static {
        dict.put(0, "zero");
        dict.put(1, "one");
        dict.put(2, "two");
        dict.put(3, "three");
        dict.put(4, "four");
        dict.put(5, "five");
        dict.put(6, "six");
        dict.put(7, "seven");
        dict.put(8, "eight");
        dict.put(9, "nine");
        dict.put(10, "ten");
    }

    static class NumberWord {
        private final Integer number;
        private final String word;

        public NumberWord(Integer number, String word) {
            this.number = number;
            this.word = word;
        }

        public Integer getNumber() {
            return this.number;
        }

        public String getWord() {
            return this.word;
        }
    }
}

