/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import org.junit.Assert;
import org.junit.Test;

public class CommandWithStubbedFallback
extends HystrixCommand<UserAccount> {
    private final int customerId;
    private final String countryCodeFromGeoLookup;

    protected CommandWithStubbedFallback(int customerId, String countryCodeFromGeoLookup) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.customerId = customerId;
        this.countryCodeFromGeoLookup = countryCodeFromGeoLookup;
    }

    protected UserAccount run() {
        throw new RuntimeException("forcing failure for example");
    }

    protected UserAccount getFallback() {
        return new UserAccount(this.customerId, "Unknown Name", this.countryCodeFromGeoLookup, true, true, false);
    }

    public static class UnitTest {
        @Test
        public void test() {
            CommandWithStubbedFallback command = new CommandWithStubbedFallback(1234, "ca");
            UserAccount account = (UserAccount)command.execute();
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertTrue((boolean)command.isResponseFromFallback());
            Assert.assertEquals((long)1234L, (long)account.customerId);
            Assert.assertEquals((Object)"ca", (Object)account.countryCode);
            Assert.assertEquals((Object)true, (Object)account.isFeatureXPermitted);
            Assert.assertEquals((Object)true, (Object)account.isFeatureYPermitted);
            Assert.assertEquals((Object)false, (Object)account.isFeatureZPermitted);
        }
    }

    public static class UserAccount {
        private final int customerId;
        private final String name;
        private final String countryCode;
        private final boolean isFeatureXPermitted;
        private final boolean isFeatureYPermitted;
        private final boolean isFeatureZPermitted;

        UserAccount(int customerId, String name, String countryCode, boolean isFeatureXPermitted, boolean isFeatureYPermitted, boolean isFeatureZPermitted) {
            this.customerId = customerId;
            this.name = name;
            this.countryCode = countryCode;
            this.isFeatureXPermitted = isFeatureXPermitted;
            this.isFeatureYPermitted = isFeatureYPermitted;
            this.isFeatureZPermitted = isFeatureZPermitted;
        }
    }
}

