/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.zenoadapter;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.write.HollowListWriteRecord;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowSetWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.zenoadapter.HollowSerializationFramework;
import com.netflix.hollow.zenoadapter.HollowSerializationRecord;
import com.netflix.zeno.fastblob.record.schema.TypedFieldDefinition;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HollowFrameworkSerializer
extends FrameworkSerializer<HollowSerializationRecord> {
    final HollowObjectHashCodeFinder hasher;
    private final ThreadLocal<Map<String, HollowSerializationRecord>> serializationRecordHandle = new ThreadLocal();
    Map<String, Map<String, String>> subTypeMap = new ConcurrentHashMap<String, Map<String, String>>();

    protected HollowFrameworkSerializer(HollowSerializationFramework framework, HollowObjectHashCodeFinder hasher) {
        super((SerializationFramework)framework);
        this.hasher = hasher;
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Integer) {
            this.serializePrimitive(rec, fieldName, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.serializePrimitive(rec, fieldName, (long)((Long)value));
        } else if (value instanceof Float) {
            this.serializePrimitive(rec, fieldName, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.serializePrimitive(rec, fieldName, (double)((Double)value));
        } else if (value instanceof Boolean) {
            this.serializePrimitive(rec, fieldName, (boolean)((Boolean)value));
        } else if (value instanceof String) {
            this.serializeString(rec, fieldName, (String)value);
        } else if (value instanceof byte[]) {
            this.serializeBytes(rec, fieldName, (byte[])value);
        } else {
            throw new RuntimeException("Primitive type " + value.getClass().getSimpleName() + " not supported!");
        }
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, int value) {
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setInt(fieldName, value);
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, long value) {
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setLong(fieldName, value);
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, float value) {
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setFloat(fieldName, value);
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, double value) {
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setDouble(fieldName, value);
    }

    public void serializePrimitive(HollowSerializationRecord rec, String fieldName, boolean value) {
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setBoolean(fieldName, value);
    }

    public void serializeBytes(HollowSerializationRecord rec, String fieldName, byte[] value) {
        if (value == null) {
            return;
        }
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setBytes(fieldName, value);
    }

    public void serializeString(HollowSerializationRecord rec, String fieldName, String value) {
        if (value == null) {
            return;
        }
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        writeRec.setString(fieldName, value);
    }

    @Deprecated
    public void serializeObject(HollowSerializationRecord rec, String fieldName, String typeName, Object obj) {
        throw new UnsupportedOperationException();
    }

    public void serializeObject(HollowSerializationRecord rec, String fieldName, Object obj) {
        if (obj == null) {
            return;
        }
        HollowObjectWriteRecord writeRec = (HollowObjectWriteRecord)rec.getHollowWriteRecord();
        int position = rec.getSchema().getPosition(fieldName);
        TypedFieldDefinition fieldDef = (TypedFieldDefinition)rec.getSchema().getFieldDefinition(position);
        int ordinal = this.getFramework().add(fieldDef.getSubType(), obj);
        writeRec.setReference(fieldName, ordinal);
    }

    public <T> void serializeList(HollowSerializationRecord rec, String fieldName, String typeName, Collection<T> obj) {
        if (obj == null) {
            return;
        }
        String subType = this.getSubType(rec.getSchema().getName(), fieldName);
        HollowSerializationRecord subRec = this.getRec(subType);
        int ordinal = this.serializeList(subRec, typeName, obj);
        ((HollowObjectWriteRecord)rec.getHollowWriteRecord()).setReference(fieldName, ordinal);
    }

    <T> int serializeList(HollowSerializationRecord rec, String typeName, Collection<T> obj) {
        HollowListWriteRecord listRec = (HollowListWriteRecord)rec.getHollowWriteRecord();
        listRec.reset();
        for (T t : obj) {
            if (t == null) continue;
            listRec.addElement(this.getFramework().add(typeName, t));
        }
        return this.getFramework().getStateEngine().add(rec.getTypeName(), (HollowWriteRecord)listRec);
    }

    public <T> void serializeSet(HollowSerializationRecord rec, String fieldName, String typeName, Set<T> obj) {
        if (obj == null) {
            return;
        }
        String subType = this.getSubType(rec.getSchema().getName(), fieldName);
        HollowSerializationRecord subRec = this.getRec(subType);
        int ordinal = this.serializeSet(subRec, typeName, obj);
        ((HollowObjectWriteRecord)rec.getHollowWriteRecord()).setReference(fieldName, ordinal);
    }

    <T> int serializeSet(HollowSerializationRecord rec, String typeName, Set<T> obj) {
        HollowSetWriteRecord setRec = (HollowSetWriteRecord)rec.getHollowWriteRecord();
        setRec.reset();
        for (T t : obj) {
            if (t == null) continue;
            int ordinal = this.getFramework().add(typeName, t);
            int hashCode = this.hasher.hashCode(typeName, ordinal, t);
            setRec.addElement(ordinal, hashCode);
        }
        return this.getFramework().getStateEngine().add(rec.getTypeName(), (HollowWriteRecord)setRec);
    }

    public <K, V> void serializeMap(HollowSerializationRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> obj) {
        if (obj == null) {
            return;
        }
        String subType = this.getSubType(rec.getSchema().getName(), fieldName);
        HollowSerializationRecord subRec = this.getRec(subType);
        int ordinal = this.serializeMap(subRec, keyTypeName, valueTypeName, obj);
        ((HollowObjectWriteRecord)rec.getHollowWriteRecord()).setReference(fieldName, ordinal);
    }

    <K, V> int serializeMap(HollowSerializationRecord rec, String keyTypeName, String valueTypeName, Map<K, V> obj) {
        HollowMapWriteRecord mapRec = (HollowMapWriteRecord)rec.getHollowWriteRecord();
        mapRec.reset();
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int keyOrdinal = this.getFramework().add(keyTypeName, entry.getKey());
            int valueOrdinal = this.getFramework().add(valueTypeName, entry.getValue());
            int hashCode = this.hasher.hashCode(keyTypeName, keyOrdinal, entry.getKey());
            mapRec.addEntry(keyOrdinal, valueOrdinal, hashCode);
        }
        return this.getFramework().getStateEngine().add(rec.getTypeName(), (HollowWriteRecord)mapRec);
    }

    public HollowSerializationRecord getRec(String type) {
        HollowSerializationRecord rec;
        Map<String, HollowSerializationRecord> map = this.serializationRecordHandle.get();
        if (map == null) {
            map = new HashMap<String, HollowSerializationRecord>();
            this.serializationRecordHandle.set(map);
        }
        if ((rec = map.get(type)) == null) {
            rec = this.createRec(type);
            map.put(type, rec);
        }
        return rec;
    }

    private HollowSerializationRecord createRec(String type) {
        HollowSchema schema = ((HollowSerializationFramework)this.framework).getHollowSchema(type);
        if (schema instanceof HollowListSchema) {
            return new HollowSerializationRecord((HollowWriteRecord)new HollowListWriteRecord(), type);
        }
        if (schema instanceof HollowSetSchema) {
            return new HollowSerializationRecord((HollowWriteRecord)new HollowSetWriteRecord(), type);
        }
        if (schema instanceof HollowMapSchema) {
            return new HollowSerializationRecord((HollowWriteRecord)new HollowMapWriteRecord(), type);
        }
        HollowSerializationRecord rec = new HollowSerializationRecord((HollowWriteRecord)new HollowObjectWriteRecord((HollowObjectSchema)schema), type);
        rec.setSchema(this.framework.getSerializer(type).getFastBlobSchema());
        return rec;
    }

    private HollowSerializationFramework getFramework() {
        return (HollowSerializationFramework)this.framework;
    }

    private String getSubType(String typeName, String fieldName) {
        String subtype;
        Map<String, String> map = this.subTypeMap.get(typeName);
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            this.subTypeMap.put(typeName, map);
        }
        if ((subtype = map.get(fieldName)) == null) {
            subtype = typeName + "_" + fieldName;
            map.put(fieldName, subtype);
        }
        return subtype;
    }
}

