/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.zenoadapter.util;

import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.zenoadapter.HollowSerializationFramework;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HollowStateEngineCreator {
    private final FastBlobStateEngine stateEngine;
    private final HollowSerializationFramework hollowFramework;
    private final Map<String, int[]> ordinalMappings = new ConcurrentHashMap<String, int[]>();

    public HollowStateEngineCreator(FastBlobStateEngine stateEngine, SerializerFactory serializerFactory, HollowObjectHashCodeFinder hashCodeFinder) {
        this.stateEngine = stateEngine;
        this.hollowFramework = new HollowSerializationFramework(serializerFactory, hashCodeFinder);
    }

    public void copyAllObjectsToHollowStateEngine() {
        this.hollowFramework.prepareForNextCycle();
        this.ordinalMappings.clear();
        for (Object serializer : this.stateEngine.getOrderedSerializers()) {
            FastBlobTypeDeserializationState typeState = this.stateEngine.getTypeDeserializationState(serializer.getName());
            typeState.createIdentityOrdinalMap();
        }
        SimultaneousExecutor executor = new SimultaneousExecutor(8);
        for (final NFTypeSerializer serializer : this.stateEngine.getOrderedSerializers()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    System.out.println("ADDING OBJECTS FOR TYPE " + serializer.getName());
                    FastBlobTypeDeserializationState state = HollowStateEngineCreator.this.stateEngine.getTypeDeserializationState(serializer.getName());
                    int maxOrdinal = state.maxOrdinal();
                    int[] mapping = new int[maxOrdinal + 1];
                    Arrays.fill(mapping, -1);
                    for (int i = 0; i <= maxOrdinal; ++i) {
                        Object obj = state.get(i);
                        if (obj == null) continue;
                        int ordinal = HollowStateEngineCreator.this.hollowFramework.add(serializer.getName(), obj);
                        while (ordinal >= mapping.length) {
                            int oldLength = mapping.length;
                            mapping = Arrays.copyOf(mapping, mapping.length * 2);
                            Arrays.fill(mapping, oldLength, mapping.length, -1);
                        }
                        mapping[ordinal] = i;
                    }
                    HollowStateEngineCreator.this.ordinalMappings.put(serializer.getName(), mapping);
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHollowBlobSnapshot(OutputStream os) throws IOException {
        HollowBlobWriter writer = new HollowBlobWriter(this.hollowFramework.getStateEngine());
        writer.writeSnapshot(os);
        os.flush();
    }

    public void writeHollowBlobDelta(OutputStream os) throws IOException {
        HollowBlobWriter writer = new HollowBlobWriter(this.hollowFramework.getStateEngine());
        writer.writeDelta(os);
        os.flush();
    }

    public void writeHollowBlobReverseDelta(OutputStream os) throws IOException {
        HollowBlobWriter writer = new HollowBlobWriter(this.hollowFramework.getStateEngine());
        writer.writeReverseDelta(os);
        os.flush();
    }

    public HollowWriteStateEngine getWriteStateEngine() {
        return this.hollowFramework.getStateEngine();
    }

    public HollowSerializationFramework getHollowSerializationFramework() {
        return this.hollowFramework;
    }

    public void writeHollowToFastBlobIndex(OutputStream os) throws IOException {
        System.out.println("WRITING HOLLOWBLOB -> FASTBLOB ORDINAL INDEX");
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeShort(this.ordinalMappings.size());
        for (Map.Entry<String, int[]> entry : this.ordinalMappings.entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeInt(entry.getValue().length);
            for (int i = 0; i < entry.getValue().length; ++i) {
                dos.writeInt(entry.getValue()[i]);
            }
        }
        dos.flush();
        dos.close();
    }
}

