/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.PrintStream;

public class JsonUtil {
    public static void print(JsonNode node) throws Exception {
        JsonUtil.print(node.traverse());
    }

    public static void print(JsonParser parser) throws Exception {
        JsonToken token = parser.nextToken();
        JsonUtil.print(parser, token, 0, System.out);
    }

    public static void print(JsonParser parser, PrintStream out) throws Exception {
        JsonToken token = parser.nextToken();
        JsonUtil.print(parser, token, 0, out);
    }

    private static void print(int index, String value, PrintStream out) {
        for (int i = 0; i < index; ++i) {
            out.print("\t");
        }
        out.println(value);
    }

    private static void print(JsonParser parser, JsonToken token, int index, PrintStream out) throws Exception {
        if (index == 0) {
            System.out.println("\n\n -----");
        }
        try {
            while (token != null && token != JsonToken.END_OBJECT) {
                switch (token) {
                    case START_ARRAY: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s", parser.getCurrentName(), token), out);
                        JsonUtil.print(parser, parser.nextToken(), index + 1, out);
                        break;
                    }
                    case START_OBJECT: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s", parser.getCurrentName(), token), out);
                        JsonUtil.print(parser, parser.nextToken(), index + 1, out);
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s, value=%s", parser.getCurrentName(), token, parser.getLongValue()), out);
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s, value=%s", parser.getCurrentName(), token, parser.getDoubleValue()), out);
                        break;
                    }
                    case VALUE_NULL: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s, value=NULL", parser.getCurrentName(), token), out);
                        break;
                    }
                    case VALUE_STRING: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s, value=%s", parser.getCurrentName(), token, parser.getValueAsString()), out);
                        break;
                    }
                    case VALUE_FALSE: 
                    case VALUE_TRUE: {
                        JsonUtil.print(index, String.format("fieldname=%s, token=%s, value=%s", parser.getCurrentName(), token, parser.getBooleanValue()), out);
                        break;
                    }
                    case FIELD_NAME: {
                        break;
                    }
                    case END_ARRAY: 
                    case END_OBJECT: {
                        --index;
                        break;
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

