/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HollowJsonAdapterPrimaryKeyFinder {
    private final Map<String, HollowSchema> hollowSchemas = new HashMap<String, HollowSchema>();
    private final String typeName;
    private final Object[] keyElementArray;
    private final Map<String, Integer> keyFieldPathPositions;

    public HollowJsonAdapterPrimaryKeyFinder(Collection<HollowSchema> schemas, String typeName, String ... keyFieldPaths) {
        this.typeName = typeName;
        for (HollowSchema schema : schemas) {
            this.hollowSchemas.put(schema.getName(), schema);
        }
        this.keyElementArray = new Object[keyFieldPaths.length];
        this.keyFieldPathPositions = new HashMap<String, Integer>();
        for (int i = 0; i < keyFieldPaths.length; ++i) {
            this.keyFieldPathPositions.put(keyFieldPaths[i], i);
        }
    }

    public Object[] findKey(String json) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser((Reader)new StringReader(json));
        return Arrays.copyOf(this.findKey(parser), this.keyElementArray.length);
    }

    public Object[] findKey(JsonParser parser) throws IOException {
        parser.nextToken();
        HollowObjectSchema schema = (HollowObjectSchema)this.hollowSchemas.get(this.typeName);
        this.addObject(parser, schema, new StringBuilder());
        return this.keyElementArray;
    }

    private void addObject(JsonParser parser, HollowObjectSchema schema, StringBuilder currentFieldPath) throws IOException {
        JsonToken token = parser.nextToken();
        String fieldName = null;
        try {
            while (token != JsonToken.END_OBJECT) {
                fieldName = parser.getCurrentName();
                this.addObjectField(parser, token, schema, fieldName, currentFieldPath);
                token = parser.nextToken();
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to parse field=" + fieldName + ", schema=" + schema.getName() + ", token=" + token, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addObjectField(JsonParser parser, JsonToken token, HollowObjectSchema schema, String fieldName, StringBuilder currentFieldPath) throws IOException {
        if (token == JsonToken.FIELD_NAME) return;
        int fieldPosition = schema.getPosition(fieldName);
        if (fieldPosition == -1) {
            this.skipObjectField(parser, token);
            return;
        }
        int parentFieldPathLength = currentFieldPath.length();
        if (parentFieldPathLength > 0) {
            currentFieldPath.append(".");
        }
        currentFieldPath.append(fieldName);
        Integer keyFieldPosition = this.keyFieldPathPositions.get(currentFieldPath.toString());
        block0 : switch (token) {
            case START_ARRAY: {
                this.skipSubArray(parser);
                break;
            }
            case START_OBJECT: {
                String referencedType = schema.getReferencedType(fieldName);
                HollowSchema referencedSchema = this.hollowSchemas.get(referencedType);
                if (referencedSchema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
                    this.addObject(parser, (HollowObjectSchema)referencedSchema, currentFieldPath);
                    break;
                }
                this.skipObject(parser);
                break;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_STRING: {
                switch (schema.getFieldType(fieldPosition)) {
                    case BOOLEAN: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = parser.getBooleanValue();
                        break block0;
                    }
                    case INT: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = parser.getIntValue();
                        break block0;
                    }
                    case LONG: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = parser.getLongValue();
                        break block0;
                    }
                    case DOUBLE: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = parser.getDoubleValue();
                        break block0;
                    }
                    case FLOAT: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = Float.valueOf(parser.getFloatValue());
                        break block0;
                    }
                    case STRING: {
                        if (keyFieldPosition == null) break;
                        this.keyElementArray[keyFieldPosition.intValue()] = parser.getValueAsString();
                        break block0;
                    }
                    case REFERENCE: {
                        if (keyFieldPosition != null) {
                            throw new IllegalStateException("Key elements must not be REFERENCE");
                        }
                        HollowObjectSchema subSchema = (HollowObjectSchema)this.hollowSchemas.get(schema.getReferencedType(fieldPosition));
                        currentFieldPath.append(".").append(subSchema.getFieldName(0));
                        keyFieldPosition = this.keyFieldPathPositions.get(currentFieldPath.toString());
                        if (keyFieldPosition == null) break;
                        switch (subSchema.getFieldType(0)) {
                            case BOOLEAN: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = parser.getBooleanValue();
                                break;
                            }
                            case INT: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = parser.getIntValue();
                                break;
                            }
                            case LONG: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = parser.getLongValue();
                                break;
                            }
                            case DOUBLE: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = parser.getDoubleValue();
                                break;
                            }
                            case FLOAT: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = Float.valueOf(parser.getFloatValue());
                                break;
                            }
                            case STRING: {
                                if (keyFieldPosition == null) break;
                                this.keyElementArray[keyFieldPosition.intValue()] = parser.getValueAsString();
                                break;
                            }
                            case REFERENCE: {
                                throw new IllegalStateException("Key elements must not be REFERENCE");
                            }
                        }
                        break block0;
                    }
                }
            }
            case VALUE_NULL: {
                break;
            }
        }
        currentFieldPath.setLength(parentFieldPathLength);
    }

    private void skipObject(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        try {
            while (token != JsonToken.END_OBJECT) {
                this.skipObjectField(parser, token);
                token = parser.nextToken();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void skipSubArray(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            if (token == JsonToken.START_OBJECT) {
                this.skipObject(parser);
            } else {
                this.skipObjectField(parser, token);
            }
            token = parser.nextToken();
        }
    }

    private void skipObjectField(JsonParser parser, JsonToken token) throws IOException {
        switch (token) {
            case START_ARRAY: {
                this.skipSubArray(parser);
                break;
            }
            case START_OBJECT: {
                this.skipObject(parser);
                break;
            }
        }
    }
}

