/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunker;
import com.netflix.hollow.jsonadapter.field.FieldProcessor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public abstract class AbstractHollowJsonAdaptorTask {
    public static boolean isDebug = false;
    protected final int maxWorkQueue = 2048;
    protected final SimultaneousExecutor executor = new SimultaneousExecutor();
    protected final String typeName;
    protected final String actionName;
    protected final Map<String, Map<String, FieldProcessor>> fieldProcessors;

    public AbstractHollowJsonAdaptorTask(String typeName, String actionName) {
        this.typeName = typeName;
        this.actionName = actionName;
        this.fieldProcessors = new HashMap<String, Map<String, FieldProcessor>>();
    }

    public void addFieldProcessor(FieldProcessor ... processors) {
        for (FieldProcessor p : processors) {
            Map<String, FieldProcessor> entityFieldProcessors = this.fieldProcessors.get(p.getEntityName());
            if (entityFieldProcessors == null) {
                entityFieldProcessors = new HashMap<String, FieldProcessor>();
                this.fieldProcessors.put(p.getEntityName(), entityFieldProcessors);
            }
            entityFieldProcessors.put(p.getFieldName(), p);
        }
    }

    public FieldProcessor getFieldProcessor(String entityName, String fieldName) {
        Map<String, FieldProcessor> entityFieldProcessors = this.fieldProcessors.get(entityName);
        if (entityFieldProcessors == null) {
            return null;
        }
        return entityFieldProcessors.get(fieldName);
    }

    protected void processFile(File f, int maxSample) throws Exception {
        this.processFile(new FileReader(f), maxSample);
    }

    protected void processFile(Reader r, int maxSample) throws Exception {
        JsonArrayChunker chunker = new JsonArrayChunker(r, (Executor)this.executor);
        chunker.initialize();
        Reader jsonObj = chunker.nextChunk();
        for (int counter = 0; jsonObj != null && counter < maxSample; ++counter) {
            final Reader currentObject = jsonObj;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonFactory factory = new JsonFactory();
                        JsonParser parser = factory.createParser(currentObject);
                        AbstractHollowJsonAdaptorTask.this.processRecord(parser);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            while (this.executor.getQueue().size() > 2048) {
                Thread.sleep(5L);
            }
            jsonObj.close();
            jsonObj = chunker.nextChunk();
        }
        this.executor.awaitSuccessfulCompletion();
    }

    protected abstract int processRecord(JsonParser var1) throws IOException;

    protected boolean wait(List<Future<?>> futureList) throws Exception {
        boolean isSuccess = false;
        for (Future<?> f : futureList) {
            try {
                f.get();
                isSuccess = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return isSuccess;
    }
}

